<?php

namespace SoapBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class StackOverFlowerController extends Controller
{
  /**
   * @Route("/soap/test/stackoverflower", name="api_soap_test_stackoverflower")
   */
  public function indexAction()
  {
    ini_set("soap.wsdl_cache_enabled", "0");

    $options = array(
      'uri' => 'http://dev.unimed.com.br/app_dev.php/api/soap/test/stackoverflower',
      'cache_wsdl' => WSDL_CACHE_NONE,
      'exceptions' => true
    );

    $server = new \SoapServer(dirname(__FILE__).'/../../../web/soap/stackoverflower.wsdl', $options);
    $server->setObject($this->get('stackoverflower_service'));

    $response = new Response();
    $response->headers->set('Content-Type', 'text/xml; charset=utf-8');

    ob_start();
    $server->handle();
    $response->setContent(ob_get_clean());

    return $response;
  }

  /**
   * @Route("/soap/test/stackoverflower/new", name="api_soap_test_stackoverflower_new")
   */
  public function testNewAction(Request $request)
  {
    $service = $this->get('stackoverflower_service');
    $result = $service->newStack($request->query->get('name'));

    return $this->render('SoapBundle:StackOverFlower:default.html.twig', array('status' => $result));
  }

  /**
   * @Route("/soap/test/stackoverflower/edit", name="api_soap_test_stackoverflower_edit")
   */
  public function testEditAction(Request $request)
  {
    $service = $this->get('stackoverflower_service');
    $result = $service->edit($request->query->get('id'), $request->query->get('name'));

    return $this->render('SoapBundle:StackOverFlower:default.html.twig', array('status' => $result));
  }

  /**
   * @Route("/soap/test/stackoverflower/list", name="api_soap_test_stackoverflower_list")
   */
  public function testGetListAction(Request $request)
  {
    $service = $this->get('stackoverflower_service');
    $result = $service->getList();

    return $this->render('SoapBundle:StackOverFlower:default.html.twig', array('list' => $result));
  }

  /**
   * @Route("/soap/test/stackoverflower/delete", name="api_soap_test_stackoverflower_delete")
   */
  public function testDeleteAction(Request $request)
  {
    $service = $this->get('stackoverflower_service');
    $result = $service->delete($request->query->get('id'));

    return $this->render('SoapBundle:StackOverFlower:default.html.twig', array('list' => $result));
  }
}
