<?php

namespace SoapBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Zend\Soap;

class UserSoapController extends Controller
{
    public function init()
    {
        // No cache
        ini_set('soap.wsdl_cache_enable', 0);
        ini_set('soap.wsdl_cache_ttl', 0);
    }

    /**
     * @Route("/soap/user/", name="api_soap_user_index")
     */
    public function indexAction()
    {
        // if(isset($_GET['wsdl'])) {
        //     return $this->handleWSDL($this->generateUrl('api_soap_user_index', array(), true), 'user_service');
        // } else {
        //     return $this->handleSOAP($this->generateUrl('api_soap_user_index', array(), true), 'user_service');
        // }
        ini_set("soap.wsdl_cache_enabled", "0");

        $options = array(
            'uri' => $this->generateUrl('api_soap_user_index', array(), true),
            'cache_wsdl' => WSDL_CACHE_NONE,
            'exceptions' => true
          );

        $server = new \SoapServer(dirname(__FILE__).'/../../../web/soap/unimed_user.wsdl', $options);
        $server->setObject($this->get('user_service'));

        $response = new Response();
        $response->headers->set('Content-Type', 'text/xml; charset=utf-8');

        ob_start();
        $server->handle();
        $response->setContent(ob_get_clean());

        return $response;
    }

    /**
    * return the WSDL
    */
    public function handleWSDL($uri, $class)
    {
        // Soap auto discover
        $autodiscover = new Soap\AutoDiscover();
        $autodiscover->setClass($this->get($class));
        $autodiscover->setUri($uri);

        // Response
        $response = new Response();
        $response->headers->set('Content-Type', 'text/xml; charset=ISO-8859-1');
        ob_start();

        // Handle Soap
        $autodiscover->handle();
        $response->setContent(ob_get_clean());
        return $response;
    }

    /**
     * @Route("/soap/user/testGetToken", name="api_soap_user_gettoken")
     */
    public function testGetTokenAction()
    {
        $client = new \SoapClient("http://hml.lmssambatech.com.br/app_dev.php/api/soap/user/?wsdl");
        $response = $client->GetToken($user = 'unimedbh', $password = 'irWuTaMfhLWp3e4Y21TI');
        var_dump($response);
    }



    /**
     * @Route("/soap/user/testListar", name="api_soap_user_listar")
     */
    public function testListarAction()
    {
        $client = new \SoapClient("http://dev.unimed.com.br/app_dev.php/api/soap/user/?wsdl");
        $response = $client->Listar($token = '07da7f596b976cc58a82007a13b21a23', "");
        var_dump($response);
    }

    /**
     * @Route("/soap/user/testCriar", name="api_soap_user_criar")
     */
    public function testCriarAction()
    {
        $parametros = array(
            "user_status" => 'Ativo',
            "job_role" => 'Analista',
            "sector" => 'Desenvolvimento',
            "email" => 'wifra@unimedbh.com.br',
            "enabled" => 'true',
            "first_name" => 'Wilmar',
            "last_name" => 'Teste PHP',
            "celphone" => '(33) 3333-33333',
            "phone" => '(33) 3333-33333',
            "num_enterprise" => '1',
            "tip_colaborador" => '1',
            "mat_colaborador" => '1900',
            "numCadSuperior" => '13535',
            "codPes" => '00000000000',
            "photo" => ''
        );

        $client = new \SoapClient("http://hml.lmssambatech.com.br/app_dev.php/api/soap/user/?wsdl");
        $response = $client->Criar($token = 'c4db1e5a81840027aa709c4860e61f65', $parametros);
        var_dump($response);
    }

    /**
     * execute SOAP request
     */
    public function handleSOAP($uri, $class)
    {
        // Soap server
        $soap = new Soap\Server(
            null,
            array(
                'location' => $uri,
                'uri' => $uri,
            )
        );
        $soap->setClass($this->get($class));

        // Response
        $response = new Response();
        $response->headers->set('Content-Type', 'text/xml; charset=ISO-8859-1');

        ob_start();
        // Handle Soap
        $soap->handle();
        $response->setContent(ob_get_clean());
        return $response;
    }
}
