<?php

namespace SoapBundle\Services;

use Doctrine\ORM\EntityManager;
use AppBundle\Entity\Course;
use AppBundle\Entity\Module;
use AppBundle\Entity\Lesson;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;

class CourseService
{

  protected $container;
  protected $em;
  protected $logger;
  protected $token = "token";
  protected $soapUser;
  protected $soapPassword;
  protected $salt = "cb5qhiIGEdvx%wc66d9iLfnn9qsJ*mZc";

  /**
   * Obtém o token de permissão
   * @param String $user
   * @param String $password
   * @return array
   */
  public function GetToken($user, $password)
  {
      $this->APIValidateUser($user, $password);
    //   $response = array(
    //       'token' => md5(date('h').$this->salt),
    //   );
      //
    //   return new \SoapVar($response, SOAP_ENC_OBJECT);
    $xml = '<return>
        <token>'.md5(date('h').$this->salt).'</token>
        </return>';
    return new \SoapVar($xml, XSD_ANYXML);
  }

  private function APIValidateUser($user, $password){
    if($user != $this->soapUser || $password != $this->soapPassword){
        throw new \SoapFault("Server", "Incorrect user/password");
    }

  }

  public function __construct($container, EntityManager $em, $logger, $api_user, $api_password)
  {
      $this->container = $container;
      $this->em        = $em;
      $this->logger    = $logger;
      $this->soapUser    = $api_user;
      $this->soapPassword    = $api_password;
  }

  private function APIValidate($token){
      $myToken = md5(date('h').$this->salt);
      if ($token != $myToken) {
          throw new \SoapFault("Server", "Incorrect token ");
      }
  }

  /**
   * Listar os cursos
   * @param String $token
   * @return array
   */
  public function Listar($token)
  {
    try{
      $this->APIValidate($token);
      $courseList = $this->em->getRepository('AppBundle:Course')->findAll();
      $courses = array();
      $itemXML = "";
      foreach ($courseList as $key => $value) {

        // $course = new \SoapVar(array(
        //     'nomEvn' => $value->getName(),
        //     'codEvn' => $value->getCodeevent(),
        //     'ideEvn' => $value->getIdevent(),
        //     'codCua' => $value->getCodcurso(),
        //     'datIni' => $value->getDtInitial()!=null?$value->getDtInitial()->format('d/m/Y'):"",
        //     'datFim' => $value->getDtEnd()!=null?$value->getDtEnd()->format('d/m/Y'):"",
        //     'datCan' => $value->getDtCancel()!=null?$value->getDtCancel()->format('d/m/Y'):"",
        //     'carHor' => $value->getDuracaoCurso(),
        //     'qtdVag' => $value->getQuantvagas(),
        //     'qtdVag' => $value->getQuantvagas(),
        //     'tipRea' => $value->getType(),
        //     'sitEvn' => $value->getSituacao(),
        //     'medCua' => $value->getNotaMedia(),
        //     'nomCua' => $value->getNameevent(),
        //     'praRea' => $value->getDisponibleDays(),
        // ), SOAP_ENC_OBJECT);
        // array_push($courses, $course);

        $dataInicial = "";
        if($value->getDtInitial()!=null){
            $dataInicial = $value->getDtInitial()->format('d/m/Y');
        }
        $dataEnd = "";
        if($value->getDtEnd()!=null){
            $dataEnd = $value->getDtEnd()->format('d/m/Y');
        }
        $dataCan = "";
        if($value->getDtCancel()!=null){
            $dataCan = $value->getDtCancel()->format('d/m/Y');
        }

        $itemXML.= '<item>';
        $itemXML.= '<nomEvn>'.$value->getName().'</nomEvn>';
        $itemXML.= '<codEvn>'.$value->getCodeevent().'</codEvn>';
        $itemXML.= '<ideEvn>'.$value->getIdevent().'</ideEvn>';
        $itemXML.= '<codCua>'.$value->getCodcurso().'</codCua>';
        $itemXML.= '<datIni>'.$dataInicial.'</datIni>';
        $itemXML.= '<datFim>'.$dataEnd.'</datFim>';
        $itemXML.= '<datCan>'.$dataCan.'</datCan>';
        $itemXML.= '<carHor>'.$value->getDuracaoCurso().'</carHor>';
        $itemXML.= '<qtdVag>'.$value->getQuantvagas().'</qtdVag>';
        $itemXML.= '<tipRea>'.$value->getType().'</tipRea>';
        $itemXML.= '<sitEvn>'.$value->getSituacao().'</sitEvn>';
        $itemXML.= '<medCua>'.$value->getNotaMedia().'</medCua>';
        $itemXML.= '<nomCua>'.$value->getNameevent().'</nomCua>';
        $itemXML.= '<praRea>'.$value->getDisponibleDays().'</praRea>';
        $itemXML.= '</item>';
      }
    //   $result = array(
    //       'codRet' => 0,
    //       'cursos' => $courses,
    //       'erroExecucao' => ""
    //   );
      //
    //   return new \SoapVar($result, SOAP_ENC_OBJECT);

      $xml = "<return>";
      $xml.= "<codRet>0</codRet>";
      $xml.= "<erroExecucao></erroExecucao>";
      $xml.= "<cursos>".$itemXML."</cursos>";
      $xml.= "</return>";

      return new \SoapVar($xml, XSD_ANYXML);
    } catch (Exception $e) {
        $error = utf8_encode($e);
        // $result = array(
        //     'erroExecucao' => $error
        // );
        // return new \SoapVar($result, SOAP_ENC_OBJECT);
        $xml = "<return>";
        $xml.= "<codRet>1</codRet>";
        $xml.= "<menRet>Error</menRet>";
        $xml.= "<erroExecucao>".$error."</erroExecucao>";
        $xml.= "</return>";

        return new \SoapVar($xml, XSD_ANYXML);
    }
  }

  /**
   * Criar curso
   * @param String $token
   * @param array $parameters
   * @return array
   */
  public function Criar($token, $parameters)
  {
      $this->APIValidate($token);

      try {
          $item = $this->xmlToarray($parameters);
          $course = new Course();

          $course->setName($item['nomEvn']);
          //novos campos
          $course->setCodeevent($item['codEvn']);
          $course->setIdevent($item['ideEvn']);
          $course->setCodcurso($item['codCua']);
          if ($item['datIni'] != null && $item['datIni'] != "") {
              $datIni = date_create_from_format("d/m/Y", $item['datIni']);
              $course->setDtInitial($datIni);
          }
          if ($item['datFim'] != null && $item['datFim'] != "") {
              $datFim = date_create_from_format("d/m/Y", $item['datFim']);
              $course->setDtEnd($datFim);
          }
          if ($item['datCan'] != null && $item['datCan'] != "") {
              $datCan = date_create_from_format("d/m/Y", $item['datCan']);
              $course->setDtCancel($datCan);
          }
          $course->setDuracaoCurso($item['carHor']);
          $course->setQuantvagas($item['qtdVag']);
          $course->setType($item['tipRea']);
          $course->setSituacao($item['sitEvn']);
          $course->setNotaMedia($item['medCua']);
          $course->setNameevent($item['nomCua']);
          $course->setDisponibleDays($item['praRea']);
          if ($item['sitEvn'] == '1' || $item['sitEvn'] == '2') {
              $course->setActive(true);
          } else {
              $course->setActive(false);
          }
          $this->em->persist($course);
          $this->em->flush();
          $mensagemRet = "Registro criado com sucesso!";
        //   return new \SoapVar(array(
        //       'codRet' => 0,
        //       'codEvn' => $course->getCodeevent(),
        //       'menRet' => $mensagemRet,
        //       'erroExecucao' => ""
        //   ), SOAP_ENC_OBJECT);
          //
        //   return new \SoapVar($result, SOAP_ENC_OBJECT);

          $xml = "<return>";
          $xml.= "<codRet>0</codRet>";
          $xml.= "<codEvn>".$course->getCodeevent()."</codEvn>";
          $xml.= "<menRet>Registro criado com sucesso</menRet>";
          $xml.= "</return>";

          return new \SoapVar($xml, XSD_ANYXML);

      } catch (Exception $e) {
          $error = utf8_encode($e);
        //   $result = array(
        //       'erroExecucao' => $error
        //   );
        //   return new \SoapVar($result, SOAP_ENC_OBJECT);

          $xml = "<return>";
          $xml.= "<codRet>1</codRet>";
          $xml.= "<menRet>Error</menRet>";
          $xml.= "<erroExecucao>".$error."</erroExecucao>";
          $xml.= "</return>";

          return new \SoapVar($xml, XSD_ANYXML);
      }
  }

  /**
   * Desativar curso
   * @param String $token
   * @param Integer $codEvn
   * @return array
   */
  public function Desativar($token, $codEvn)
  {
    $this->APIValidate($token);
    try {
      $course = $this->em->getRepository('AppBundle:Course')->findOneBy(
        array('codeevent'=>$codEvn)
      );
      if($course == null){
        // return new \SoapVar(array(
        //     'codRet' => 1,
        //     'menRet' => "Curso nao encontrado."
        // ), SOAP_ENC_OBJECT);
        $xml = "<return>";
        $xml.= "<codRet>1</codRet>";
        $xml.= "<menRet>Curso nao encontrado</menRet>";
        $xml.= "<erroExecucao></erroExecucao>";
        $xml.= "</return>";

        return new \SoapVar($xml, XSD_ANYXML);
      }
      $course->setActive(false);
      $this->em->persist($course);
      $this->em->flush();
    //   return new \SoapVar(array(
    //       'codRet' => 0,
    //       'menRet' => "Registro desativado com sucesso."
    //   ), SOAP_ENC_OBJECT);

      $xml = "<return>";
      $xml.= "<codRet>0</codRet>";
      $xml.= "<menRet>Registro desativado com sucesso</menRet>";
      $xml.= "<erroExecucao></erroExecucao>";
      $xml.= "</return>";

      return new \SoapVar($xml, XSD_ANYXML);
    }catch (\Exception $e) {
        $error = utf8_encode($e);
        // return new \SoapVar(array(
        //     'codRet' => 1,
        //     'menRet' => "Error",
        //     'erroExecucao' => $error
        // ), SOAP_ENC_OBJECT);

        $xml = "<return>";
        $xml.= "<codRet>1</codRet>";
        $xml.= "<menRet>Error</menRet>";
        $xml.= "<erroExecucao>".$error."</erroExecucao>";
        $xml.= "</return>";

        return new \SoapVar($xml, XSD_ANYXML);
    }
  }

  /**
   * Alterar curso
   * @param String $token
   * @param array $parameters
   * @return array
   */
  public function Alterar($token, $parameters)
  {
    $this->APIValidate($token);
    try {
        $item = $this->xmlToarray($parameters);
        $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
            'codeevent' =>  $item['codEvn']
        ));
        if(!$course){
        //   return new \SoapVar(array(
        //       'codRet' => 1,
        //       'menRet' => "Error",
        //       'erroExecucao' => "Curso nao encontrado"
        //   ), SOAP_ENC_OBJECT);
            $xml = "<return>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<menRet>Error</menRet>";
            $xml.= "<erroExecucao>Curso nao encontrado</erroExecucao>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
        $course->setName($item['nomEvn']);
        //novos campos
        $course->setCodeevent($item['codEvn']);
        $course->setIdevent($item['ideEvn']);
        $course->setCodcurso($item['codCua']);
        if ($item['datIni'] != null && $item['datIni'] != "") {
            $datIni = date_create_from_format("d/m/Y", $item['datIni']);
            $course->setDtInitial($datIni);
        }
        if ($item['datFim'] != null && $item['datFim'] != "") {
            $datFim = date_create_from_format("d/m/Y", $item['datFim']);
            $course->setDtEnd($datFim);
        }
        if ($item['datCan'] != null && $item['datCan'] != "") {
            $datCan = date_create_from_format("d/m/Y", $item['datCan']);
            $course->setDtCancel($datCan);
        }
        $course->setDuracaoCurso($item['carHor']);
        $course->setQuantvagas($item['qtdVag']);
        $course->setType($item['tipRea']);
        $course->setSituacao($item['sitEvn']);
        $course->setNotaMedia($item['medCua']);
        $course->setNameevent($item['nomCua']);
        $course->setDisponibleDays($item['praRea']);
        if ($item['sitEvn'] == '1' || $item['sitEvn'] == '2') {
            $course->setActive(true);
        } else {
            $course->setActive(false);
        }
        $this->em->persist($course);
        $this->em->flush();
        // $mensagemRet = "Registro alterado com sucesso!";
        // return new \SoapVar(array(
        //     'codRet' => 0,
        //     'codEvn' => $course->getCodeevent(),
        //     'menRet' => $mensagemRet,
        //     'erroExecucao' => ""
        // ), SOAP_ENC_OBJECT);
        //
        // return new \SoapVar($result, SOAP_ENC_OBJECT);

        $xml = "<return>";
        $xml.= "<codRet>0</codRet>";
        $xml.= "<codEvn>".$course->getCodeevent()."</codEvn>";
        $xml.= "<menRet>Registro alterado com sucesso</menRet>";
        $xml.= "</return>";
        return new \SoapVar($xml, XSD_ANYXML);

    } catch (Exception $e) {
        $error = utf8_encode($e);
        // $result = array(
        //     'erroExecucao' => $error
        // );
        // return new \SoapVar($result, SOAP_ENC_OBJECT);
        $xml = "<return>";
        $xml.= "<codRet>1</codRet>";
        $xml.= "<menRet>Error</menRet>";
        $xml.= "<erroExecucao>".$error."</erroExecucao>";
        $xml.= "</return>";

        return new \SoapVar($xml, XSD_ANYXML);
    }
    return $course;
  }

  private function xmlToarray($xmlObject, $out = array())
  {
      foreach ((array) $xmlObject as $index => $node)
          $out[$index] = (is_object($node)) ? $this->xmlToarray($node) : $node;

      return $out;
  }
}
