<?php

namespace SoapBundle\Services;

use Doctrine\ORM\EntityManager;
use JMS\Serializer\SerializerBuilder;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\InscriptionStatus;

class InscriptionService
{

    protected $container;
    protected $em;
    protected $logger;
    protected $token = "token";
    protected $soapUser;
    protected $soapPassword;
    protected $salt = "cb5qhiIGEdvx%wc66d9iLfnn9qsJ*mZc";

    /**
     * Obtém o token de permissão
     * @param String $user
     * @param String $password
     * @return array
     */
    public function GetToken($user, $password)
    {
        $this->APIValidateUser($user, $password);
        // $response = array(
        //     'token' => md5(date('h').$this->salt),
        // );
        //
        // return new \SoapVar($response, SOAP_ENC_OBJECT);
        $xml = '<return>
            <token>'.md5(date('h').$this->salt).'</token>
            </return>';
        return new \SoapVar($xml, XSD_ANYXML);
    }

    private function APIValidateUser($user, $password){
      if($user != $this->soapUser || $password != $this->soapPassword){
          throw new \SoapFault("Server", "Incorrect user/password");
      }

    }

    private function APIValidate($token)
    {
        $myToken = md5(date('h').$this->salt);
        if ($token != $myToken) {
            throw new \SoapFault("Server", "Incorrect token ");
        }

    }

    public function __construct($container, EntityManager $em, $logger, $api_user, $api_password)
    {
        $this->container = $container;
        $this->em        = $em;
        $this->logger    = $logger;
        $this->soapUser    = $api_user;
        $this->soapPassword    = $api_password;
    }

    /**
     * Matricular no curso
     * @param String $token
     * @param array $parameters
     * @return array
     */
    public function Matricular($token, $parameters)
    {
        $this->APIValidate($token);
        try {

            $item = $this->xmlToarray($parameters);
            $user = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                'mat_colaborador' => $item['numCad']
            ));
            if (!$user) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Aluno nao encontrado"
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Aluno nao encontrado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

            $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                'codeevent' => $item['codEvn']
            ));
            if (!$course) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Curso nao encontrado"
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Curso nao encontrado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

            $courseQuantVagas    = $course->getQuantvagas();
            $inscriptionStatusAprovado = $this->em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);
            $inscriptionOfCourse = $this->em->getRepository('AppBundle:Inscription')->findBy(array(
                'course' => $course,
                'inscription_status' => $inscriptionStatusAprovado,
            ));

            if (intval($courseQuantVagas) <= count($inscriptionOfCourse)){
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Não há vagas para o no curso informado."
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Não há vagas para o no curso informado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

            $inscription = $this->em->getRepository('AppBundle:Inscription')->findOneBy(array(
                'course' => $course,
                'user' => $user
            ));

            if (!$inscription) {
                $inscriptionStatus = $this->em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);
                $inscription       = new Inscription();
                $inscription->setCourse($course);
                $inscription->setUser($user);
                $inscription->setInscriptionStatus($inscriptionStatus);
                $this->em->persist($inscription);
                $this->em->flush();
                // $response = array(
                //     'codRet' => 0,
                //     'erroExecucao' => "",
                //     'menRet' => "Matricula realizada",
                //     'numCad' => $item['numCad'],
                //     'codEvn' => $item['codEvn']
                // );
                // return new \SoapVar($response, SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>0</codRet>";
                $xml.= "<menRet>Matricula realizada</menRet>";
                $xml.= "<erroExecucao></erroExecucao>";
                $xml.= "<numCad>".$item['numCad']."</numCad>";
                $xml.= "<codEvn>".$item['codEvn']."</codEvn>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);


            } else {
                // $response = array(
                //     'codRet' => 0,
                //     'erroExecucao' => "",
                //     'menRet' => "Matricula existente",
                //     'numCad' => $item['numCad'],
                //     'codEvn' => $item['codEvn']
                // );
                //
                // return new \SoapVar($response, SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Matricula existente</menRet>";
                $xml.= "<erroExecucao></erroExecucao>";
                $xml.= "<numCad>".$item['numCad']."</numCad>";
                $xml.= "<codEvn>".$item['codEvn']."</codEvn>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

        }
        catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'menRet' => "Error",
            //     'erroExecucao' => $error
            // ), SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<menRet>Error</menRet>";
            $xml.= "<erroExecucao>".$error."</erroExecucao>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    /**
     * Remover uma matricula
     * @param String $token
     * @param array $parameters
     * @return array
     */
    public function Remover($token, $parameters)
    {
        $this->APIValidate($token);
        try {
            $item = $this->xmlToarray($parameters);
            $user = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                'numCad' => $item['numCad']
            ));
            if (!$user) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Aluno nao encontrado"
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Aluno nao encontrado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

            $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                'codeevent' => $item['codEvn']
            ));
            if (!$course) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Curso nao encontrado"
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Curso nao encontrado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

            $inscription = $this->em->getRepository('AppBundle:Inscription')->findOneBy(array(
                'course' => $course,
                'user' => $user
            ));
            if ($inscription) {
                $this->em->remove($inscription);
                $this->em->flush();
                // return new \SoapVar(array(
                //     'codRet' => 0,
                //     'numCad' => $item['numCad'],
                //     'codEvn' => $item['codEvn'],
                //     'menRet' => "Matricula removida com sucesso."
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>0</codRet>";
                $xml.= "<menRet>Matricula removida com sucesso</menRet>";
                $xml.= "<erroExecucao></erroExecucao>";
                $xml.= "<numCad>".$item['numCad']."</numCad>";
                $xml.= "<codEvn>".$item['codEvn']."</codEvn>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            } else {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'numCad' => $item['numCad'],
                //     'codEvn' => $item['codEvn'],
                //     'menRet' => "Matricula inexistente."
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Matricula inexistente</menRet>";
                $xml.= "<erroExecucao></erroExecucao>";
                $xml.= "<numCad>".$item['numCad']."</numCad>";
                $xml.= "<codEvn>".$item['codEvn']."</codEvn>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }
        }
        catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'menRet' => "Error",
            //     'erroExecucao' => $error
            // ), SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<menRet>Error</menRet>";
            $xml.= "<erroExecucao>".$error."</erroExecucao>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    /**
     * Listar matriculas de um curso
     * @param String $token
     * @param String $codEvn
     * @return array
     */
    public function Listar($token, $codEvn)
    {
        $this->APIValidate($token);
        try {
            $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                'codeevent' => $codEvn
            ));
            if (!$course) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Curso nao encontrado"
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Curso nao encontrado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }
            $inscriptionList = $this->em->getRepository('AppBundle:Inscription')->findBy(array(
                'course' => $course
            ));
            $inscriptions    = array();
            $itemXML = "";
            foreach ($inscriptionList as $key => $value) {
                $client      = $this->em->getRepository('AppBundle:Client')->find($value->getUser()->getId());
                // $inscription = new \SoapVar(array(
                //     'numCad' => $client->getNumCad()
                // ), SOAP_ENC_OBJECT);
                // array_push($inscriptions, $inscription);
                $itemXML.="<item>";
                $itemXML.="<numCad>".$client->getMatColaborador()."</numCad>";
                $itemXML.="</item>";
            }

            // $response = array(
            //     'codRet' => 0,
            //     'erroExecucao' => "",
            //     'matriculas' => $inscriptions
            // );
            // return new \SoapVar($response, SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml.= "<codRet>0</codRet>";
            $xml.= "<erroExecucao></erroExecucao>";
            $xml.= "<matriculas>".$inscriptions."</matriculas>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
        catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'menRet' => "Error",
            //     'erroExecucao' => $error
            // ), SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<menRet>Error</menRet>";
            $xml.= "<erroExecucao>".$error."</erroExecucao>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    /**
     * Listar alunos que concluíram um curso
     * @param String $token
     * @param String $codEvn
     * @return array
     */
    public function ListarConcluidos($token, $codEvn)
    {
        $this->APIValidate($token);
        try {
            $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                'codeevent' => $codEvn
            ));
            if (!$course) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Error",
                //     'erroExecucao' => "Curso nao encontrado"
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>Error</menRet>";
                $xml.= "<erroExecucao>Curso nao encontrado</erroExecucao>";
                $xml.= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }
            $userEvaluationRepository = $this->em->getRepository('AppBundle:UserEvaluation');
            $userEvaluations = $userEvaluationRepository->getEvaluationEvent($codEvn);
            $inscriptions    = array();
            $itemXML = "";
            foreach ($userEvaluations as $key => $value) {
                $client      = $this->em->getRepository('AppBundle:Client')->find($value->getUser()->getId());
                $itemXML.="<item>";
                $itemXML.="<numCad>".$client->getMatColaborador()."</numCad>";
                $itemXML.="<nota>".$value->getGrade()."</nota>";
                $itemXML.="</item>";
                // $inscription = new \SoapVar(array(
                //     'numCad' => $client->getNumCad(),
                //     'nota' => $client->getGrade()
                // ), SOAP_ENC_OBJECT);
                // array_push($inscriptions, $inscription);
            }

            $response = array(
                'codRet' => 0,
                'erroExecucao' => "",
                'matriculas' => $inscriptions
            );
            return new \SoapVar($response, SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml.= "<codRet>0</codRet>";
            $xml.= "<erroExecucao></erroExecucao>";
            $xml.= "<matriculas>".$itemXML."</matriculas>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
        catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'menRet' => "Error",
            //     'erroExecucao' => $error
            // ), SOAP_ENC_OBJECT);
            $xml = "<return>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<menRet>Error</menRet>";
            $xml.= "<erroExecucao>".$error."</erroExecucao>";
            $xml.= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    private function xmlToarray($xmlObject, $out = array())
    {
        foreach ((array) $xmlObject as $index => $node)
            $out[$index] = (is_object($node)) ? $this->xmlToarray($node) : $node;

        return $out;
    }
}
