<?php

namespace SoapBundle\Services;

use Doctrine\ORM\EntityManager;
use AppBundle\Entity\Client;
use AppBundle\Entity\Course;
use AppBundle\Entity\Module;
use AppBundle\Entity\Lesson;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\UserEvaluation;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;

class SoapService
{
    protected $container;
    protected $em;
    protected $logger;
    protected $soapUser;
    protected $soapPassword;
    protected $salt = "cb5qhiIGEdvx%wc66d9iLfnn9qsJ*mZc";

    /**
     * Obtém o token de permissão
     * @param String $user
     * @param String $password
     * @return array
     */
    public function GetToken($user, $password)
    {
        $this->APIValidateUser($user, $password);
        // $response = array(
        //     'token' => md5(date('h').$this->salt),
        // );
        //
        // return new \SoapVar($response, SOAP_ENC_OBJECT);
        $xml = '<return>
            <token>'.md5(date('h').$this->salt).'</token>
            </return>';
        return new \SoapVar($xml, XSD_ANYXML);
    }

    private function APIValidateUser($user, $password)
    {
        if ($user != $this->soapUser || $password != $this->soapPassword) {
            throw new \SoapFault("Server", "Incorrect user/password");
        }
    }

    private function APIValidate($token)
    {
        $myToken = md5(date('h').$this->salt);
        if ($token != $myToken) {
            throw new \SoapFault("Server", "Incorrect token ");
        }
    }

    public function __construct($container, EntityManager $em, $logger, $api_user, $api_password)
    {
        $this->container = $container;
        $this->em        = $em;
        $this->logger    = $logger;
        $this->soapUser    = $api_user;
        $this->soapPassword    = $api_password;
    }

    /**
     * Cadastro de Eventos LMS
     * @param String $token
     * @param Integer $encryption
     * @param array $parameters
     * @return array
     */
    public function CadastroEvento($token, $encryption, $parameters)
    {
        $this->APIValidate($token);
        try {
            $item = $this->xmlToarray($parameters);

            if ($item['codOpe'] == 'I' || $item['codOpe'] == 'A') {
                $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                  'codeevent' =>  $item['codEvn']
              ));
                if ($course != null && $item['codOpe'] == 'I') {
                    //   return new \SoapVar(array(
                    //       'codRet' => 4,
                    //       'evnLMS' => "",
                    //       'menRet' => "Error",
                    //   ), SOAP_ENC_OBJECT);

                    $xml = "<result>";
                    $xml.= "<codRet>4</codRet>";
                    $xml.= "<evnLMS>0</evnLMS>";
                    $xml.= "<menRet>Evento " .  $item['codEvn'] . " ja existente!</menRet>";
                    $xml.= "</result>";

                    return new \SoapVar($xml, XSD_ANYXML);
                }
                if ($course == null && $item['codOpe'] == 'A') {
                    // return new \SoapVar(array(
                    //     'codRet' => 3,
                    //     'evnLMS' => "",
                    //     'menRet' => "Error",
                    // ), SOAP_ENC_OBJECT);
                    $xml = "<result>";
                    $xml.= "<codRet>3</codRet>";
                    $xml.= "<evnLMS>0</evnLMS>";
                    $xml.= "<menRet>Invalid codEvn " .  $item['codEvn'] . "</menRet>";
                    $xml.= "</result>";

                    return new \SoapVar($xml, XSD_ANYXML);
                }
                if ($item['codOpe'] == 'I') {
                    $course = new Course();
                }
                $course->setName($item['nomEvn']);
                //novos campos
                $course->setCodeevent($item['codEvn']);
                $course->setIdevent($item['ideEvn']);
                $course->setCodcurso($item['codCua']);
                if ($item['datIni'] != null && $item['datIni'] != "") {
                    $datIni = date_create_from_format("d/m/Y", $item['datIni']);
                    $course->setDtInitial($datIni);
                }
                if ($item['datFim'] != null && $item['datFim'] != "") {
                    $datFim = date_create_from_format("d/m/Y", $item['datFim']);
                    $course->setDtEnd($datFim);
                }
                /*if ($item['datCan'] != null && $item['datCan'] != "") {
                    $datCan = date_create_from_format("d/m/Y", $item['datCan']);
                    $course->setDtCancel($datCan);
                }*/
                $course->setDuracaoCurso($item['carHor']);
                $course->setQuantvagas($item['qtdVag']);
                $course->setType($item['tipRea']);
                $course->setSituacao($item['sitEvn']);
                $course->setNotaMedia($item['medCua']);
                $course->setNameevent($item['nomCua']);
                $course->setDisponibleDays($item['praRea']);
                $course->setOperador($item['codOpe']);
                if ($item['sitEvn'] == '1' || $item['sitEvn'] == '2') {
                    $course->setActive(true);
                } else {
                    $course->setActive(false);
                }
                $this->em->persist($course);
                $this->em->flush();
                if ($item['codOpe'] == 'I') {
                    $mensagemRet = "Registro criado com sucesso!";
                } else {
                    $mensagemRet = "Registro atualizado com sucesso!";
                }
                //   return new \SoapVar(array(
                //       'codRet' => 0,
                //       'evnLMS' => $course->getId(),
                //       'menRet' => $mensagemRet,
                //   ), SOAP_ENC_OBJECT);

                $xml = "<result>";
                $xml.= "<codRet>0</codRet>";
                $xml.= "<evnLMS>".$course->getId()."</evnLMS>";
                $xml.= "<menRet>".$mensagemRet."</menRet>";
                $xml.= "</result>";
                return new \SoapVar($xml, XSD_ANYXML);
            } elseif ($item['codOpe'] == 'E') {
                $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                  'codeevent' => $item['codEvn']
              ));
                if ($course != null) {
                    $course_id = $course->getId();
                    $this->em->remove($course);
                    $this->em->flush();
                    //   return new \SoapVar(array(
                    //       'codRet' => 0,
                    //       'evnLMS' => $course_id,
                    //       'menRet' => "Registro excluido com sucesso!",
                    //   ), SOAP_ENC_OBJECT);

                    $xml = "<result>";
                    $xml.= "<codRet>0</codRet>";
                    $xml.= "<evnLMS>".$course_id."</evnLMS>";
                    $xml.= "<menRet>Registro excluido com sucesso!</menRet>";
                    $xml.= "</result>";
                    return new \SoapVar($xml, XSD_ANYXML);
                } else {
                    //   return new \SoapVar(array(
                    //       'codRet' => 3,
                    //       'evnLMS' => "",
                    //       'menRet' => "Error",
                    //   ), SOAP_ENC_OBJECT);

                    $xml = "<result>";
                    $xml.= "<codRet>3</codRet>";
                    $xml.= "<evnLMS>0</evnLMS>";
                    $xml.= "<menRet>Invalid codEvn". $item['codEvn']."</menRet>";
                    $xml.= "</result>";
                    return new \SoapVar($xml, XSD_ANYXML);
                }
            } else {
                //   return new \SoapVar(array(
                //       'codRet' => 2,
                //       'evnLMS' => null,
                //       'menRet' => "Error",
                //   ), SOAP_ENC_OBJECT);

                $xml = "<result>";
                $xml.= "<codRet>2</codRet>";
                $xml.= "<evnLMS>0</evnLMS>";
                $xml.= "<menRet>Invalid operation</menRet>";
                $xml.= "</result>";
                return new \SoapVar($xml, XSD_ANYXML);
            }
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'evnLMS' => null,
            //     'menRet' => "Error",
            // ), SOAP_ENC_OBJECT);

            $xml = "<result>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<evnLMS>0</evnLMS>";
            $xml.= "<menRet>".$error."</menRet>";
            $xml.= "</result>";
            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    private function xmlToarray($xmlObject, $out = array())
    {
        foreach ((array) $xmlObject as $index => $node) {
            $out[$index] = (is_object($node)) ? $this->xmlToarray($node) : $node;
        }

        return $out;
    }

    protected function validateParamsParticipante($participante)
    {
        $msgError = '';
        $tipCol = intval($participante['tipCol']);
        $sitCua = intval($participante['sitCua']);
        if (!($tipCol >= 1 and $tipCol <= 3)) {
            $msgError .= "Campo tipCol invalido."."\n";
        }

        if (!($sitCua >= 1 and $sitCua <= 10)) {
            $msgError .= "Campo sitCua invalido."."\n";
        }

        if ($participante['datIni']!="" && !preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])\/(0[1-9]|1[0-2])\/[0-9]{4}$/", $participante['datIni'])) {
            $msgError .= "Formato do campo datIni invalido."."\n";
        }

        $checkParamsDefault = $this->checkParamsCadastroParticipanteAgrupado($participante);
        if ($checkParamsDefault['error']) {
            $msgError .= $checkParamsDefault['msgError'];
        }

        return array(
            'error' => (empty($msgError)) ? false : true,
            'msgError' => $msgError,
        );
    }

    protected function removeClientAndInscription($paramsParticipante)
    {
        // $client = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
        //     'numCad' => $paramsParticipante['numCad']
        // ));

        $inscription = $this->em->getRepository('AppBundle:Inscription')->findOneBy(array(
            'user' => $client->getId()
        ));

        //$this->em->remove($client);
        $this->em->remove($inscription);
    }

    /**
     * Cadastra Participantes no LMS - Agrupado
     * @param String $token
     * @param Integer $encryption
     * @param array $processamentos
     * @return array
     */
    public function CadastroParticipanteAgrupado($token, $encryption, $parameters = array())
    {
        $this->APIValidate($token);

        try {
            $erroExecucao = 0;

            $data = $this->xmlToarray($parameters);
            $participantes = (array_key_exists('participantes', $data)) ? $this->xmlToarray($data['participantes']) : $data;
            $itemXML = "";
            foreach ($data as $key => $participante) {
                $validateParams = $this->validateParamsParticipante($participante);
                if ($validateParams['error']) {
                    $participante['menRet'] = $validateParams['msgError'];
                    // $participante = new \SoapVar($participante, SOAP_ENC_OBJECT);
                    $itemXML.= "<participantes>";
                    $itemXML.= "<codEvn>".$participante["codEvn"]."</codEvn>";
                    $itemXML.= "<numEmp>".$participante["numEmp"]."</numEmp>";
                    $itemXML.= "<tipCol>".$participante["tipCol"]."</tipCol>";
                    $itemXML.= "<numCad>".$participante["numCad"]."</numCad>";
                    $itemXML.= "<codPes>".$participante["codPes"]."</codPes>";
                    $itemXML.= "<sitCua>".$participante["sitCua"]."</sitCua>";
                    $itemXML.= "<datIni>".$participante["datIni"]."</datIni>";
                    $itemXML.= "<codRet>".$participante["codRet"]."</codRet>";
                    $itemXML.= "<menRet>".$participante["menRet"]."</menRet>";
                    $itemXML.= "<codOpe>".$participante["codOpe"]."</codOpe>";
                    $itemXML.= "</participantes>";
                    continue;
                }

                if (!$this->checkInscriptionQuantVagas($participante['codEvn'])) {
                    $participante['codRet'] = 1;
                    $participante['menRet'] .= 'Não ha vagas para o no curso informado.'."\n";
                    // $participante = new \SoapVar($participante, SOAP_ENC_OBJECT);
                    $itemXML.= "<participantes>";
                    $itemXML.= "<codEvn>".$participante["codEvn"]."</codEvn>";
                    $itemXML.= "<numEmp>".$participante["numEmp"]."</numEmp>";
                    $itemXML.= "<tipCol>".$participante["tipCol"]."</tipCol>";
                    $itemXML.= "<numCad>".$participante["numCad"]."</numCad>";
                    $itemXML.= "<codPes>".$participante["codPes"]."</codPes>";
                    $itemXML.= "<sitCua>".$participante["sitCua"]."</sitCua>";
                    $itemXML.= "<datIni>".$participante["datIni"]."</datIni>";
                    $itemXML.= "<codRet>".$participante["codRet"]."</codRet>";
                    $itemXML.= "<menRet>".$participante["menRet"]."</menRet>";
                    $itemXML.= "<codOpe>".$participante["codOpe"]."</codOpe>";
                    $itemXML.= "</participantes>";
                    continue;
                }

                if ($participante['codOpe'] == ('I') || $participante['codOpe'] == ('A')) {
                    $client = $this->createClientParticipante($participante);

                    if ($client!=null) {
                        // $this->em->persist($client);
                        $inscription = $this->createInscriptionParticipante($participante, $client);
                        // $userEvaluation = $this->setUserEvaluation($participante, $client);
                        // $this->em->persist($userEvaluation);
                        $this->em->persist($inscription);

                        if ($participante['codOpe'] == ('I')) {
                            $participante['codRet'] = 0;
                            $participante['menRet'] .= 'Registro criado com sucesso.'."\n";
                        } else {
                            $participante['codRet'] = 0;
                            $participante['menRet'] .= 'Registro editado com sucesso.'."\n";
                        }
                    } else {
                        $participante['codRet'] = 0;
                        $participante['menRet'] .= 'Usuario nao encontrado no LMS.'."\n";
                    }
                } elseif ($participante['codOpe'] == 'E') {
                    $this->removeClientAndInscription($participante);
                    $participante['codRet'] = 0;
                    $participante['menRet'] .= 'Registro deletado com sucesso.'."\n";
                } else {
                    $participante['codRet'] = 1;
                    $participante['menRet'] .= 'Campo codOpe invalido.'."\n";
                }

                $itemXML.= "<participantes>";
                $itemXML.= "<codEvn>".$participante["codEvn"]."</codEvn>";
                $itemXML.= "<numEmp>".$participante["numEmp"]."</numEmp>";
                $itemXML.= "<tipCol>".$participante["tipCol"]."</tipCol>";
                $itemXML.= "<numCad>".$participante["numCad"]."</numCad>";
                $itemXML.= "<codPes>".$participante["codPes"]."</codPes>";
                $itemXML.= "<sitCua>".$participante["sitCua"]."</sitCua>";
                $itemXML.= "<datIni>".$participante["datIni"]."</datIni>";
                $itemXML.= "<codRet>".$participante["codRet"]."</codRet>";
                $itemXML.= "<menRet>".$participante["menRet"]."</menRet>";
                $itemXML.= "<codOpe>".$participante["codOpe"]."</codOpe>";
                $itemXML.= "</participantes>";
                //$participante = new \SoapVar($participante, SOAP_ENC_OBJECT);
            }

            if ($erroExecucao == 0) {
                $this->em->flush();
            }

            // $participantes converter o array em xml esperado no retorno (documentação)
            // $response = array(
            //     'participantes' => $participantes,
            // );

            $xml = "<parameters>";
            $xml.= $itemXML;
            $xml.= "</parameters>";

            return new \SoapVar($xml, XSD_ANYXML);
        } catch (Exception $e) {
            $error    = utf8_encode($e);
            // $response = array(
            //     'participantes' => $participantes,
            // );

            $xml ="<parameters>";
            $xml.=$itemXML;
            $xml.="</parameters>";
            $xml.="<menRet>";
            $xml.=$error;
            $xml.="</menRet>";

            return new \SoapVar($xml, XSD_ANYXML);

            // return new \SoapVar($response, SOAP_ENC_OBJECT);
        }
    }

    private function checkInscriptionQuantVagas($codEnv)
    {
        $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
            'codeevent' => $codEnv
        ));

        if ($course) {
            $courseQuantVagas    = $course->getQuantvagas();
            $inscriptionStatusAprovado = $this->em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);
            // $inscriptionOfCourse = $this->em->getRepository('AppBundle:Inscription')->findBy(array(
            //     'course' => $course,
            //     'inscription_status' => $inscriptionStatusAprovado,
            // ));
            $inscriptionOfCourse = $this->em->getRepository('AppBundle:Inscription')->findTotalActiveInscriptions(
                $course,
                $inscriptionStatusAprovado
            );

            return (intval($courseQuantVagas) > intval($inscriptionOfCourse));
        }

        return false;
    }

    private function checkParamsInformaProcessamento($participante)
    {
        $error = false;
        $msgError = "";
        $fieldsRequireParams = array(
            'numEmp',
            'tipCol',
            'numCad',
            'codEvn',
            'staTus',
        );

        foreach ($fieldsRequireParams as $key) {
            if (!array_key_exists($key, $participante)) {
                $error = true;
                $msgError .= "Campo ".$key." obrigatorio";
                $msgError .= "\n";
            }
        }

        return array(
            'error' => $error,
            'msgError' => $msgError
        );
    }


    private function checkParamsCadastroParticipanteAgrupado($participante)
    {
        $error = false;
        $msgError = "";
        $fieldsRequireParams = array( 'numEmp', 'tipCol', 'numCad', 'codPes', 'sitCua',
            'codEvn', 'datIni', 'codRet', 'codOpe',
        );

        foreach ($fieldsRequireParams as $key) {
            if (!array_key_exists($key, $participante)) {
                $error = true;
                $msgError .= "Campo " . $key . " obrigatorio";
                $msgError .= "\n";
            }
        }

        return array(
            'error' => $error,
            'msgError' => $msgError
        );
    }


    private function createClientParticipante($params)
    {
        $client = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
            'mat_colaborador' => $params['numCad'],
            'num_enterprise' => $params['numEmp']
        ));

        // if (!$client) {
        //     $client = new Client();
        // }
        //
        // $client->setEmail($params['numCad']."@unimed.com.br");
        // $client->setUsername($params['numCad']);
        // $client->setEnabled(true);
        // $client->setRoles(array("ROLE_USER"));
        // $client->setNumEmp($params['numEmp']);
        // $client->setTipCol($params['tipCol']);
        // $client->setNumCad($params['numCad']);
        // $client->setCodPes($params['codPes']);
        // $client->setSitCua($params['sitCua']);
        // $encoder = $this->container->get('security.encoder_factory')->getEncoder($client);
        // //$new_pwd_encoded = $encoder->encodePassword($params['numCad']);
        // $new_pwd_encoded = $params['numCad'];
        // $client->setPassword($new_pwd_encoded);

        return $client;
    }

    private function createInscriptionParticipante($params, $client)
    {
        $inscriptionStatus = $this->em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);

        $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
            'codeevent' => $params['codEvn']
        ));

        $inscription = $this->em->getRepository('AppBundle:Inscription')->findOneBy(array(
            'course' => $course->getId(),
            'user' => $client->getId()
        ));

        if (!$inscription) {
            $inscription = new Inscription();
        }

        $inscription->setCourse($course);
        $inscription->setUser($client);
        $inscription->setInscriptionStatus($inscriptionStatus);

        if (!empty($params['datIni'])) {
            $datIni = date_create_from_format("d/m/Y", $params['datIni']);
            $inscription->setDtBegin($datIni);
        }

        return $inscription;
    }

    public function setUserEvaluation($params, $user)
    {
        $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
            'codeevent' => $params['codEvn']
        ));

        $userEvaluation = new UserEvaluation();
        $userEvaluation->setUser($user);
        $userEvaluation->setCourse($course);
        $grade = $params['sitCua'] == 2 ? 100 : 0;
        $userEvaluation->setGrade($grade);

        return $userEvaluation;
    }

    /**
     * Informa Processamento de Notas / Frequencia no evento
     * @param String $token
     * @param Integer $encryption
     * @param array $parameters
     * @return array
     */
    public function InformaProcessamento($token, $encryption, $parameters = array())
    {
        $this->APIValidate($token);
        try {
            $return = array();
            $dados = $this->xmlToarray($parameters);
            // $this->logger->error(print_r($dados, true));
            // $dados = (array_key_exists('processamentos', $dados)) ? $this->xmlToarray($dados['processamentos']) : $dados;
            $itemXML = "";
            foreach ($dados as $key => $dado) {
                $menRet = "";
                $checkParamsInformaProcessamento = $this->checkParamsInformaProcessamento($dado);
                if ($checkParamsInformaProcessamento['error']) {
                    $menRet = $checkParamsInformaProcessamento['msgError'];
                } else {
                    $dado['staTus'] = 'N';
                    $userEvaluations = $this->em->getRepository('AppBundle:UserEvaluation')->getEvaluationUserEvent($dado['numCad'], $dado['codEvn']);
                    foreach ($userEvaluations as $userEvaluation) {
                        $userEvaluation->setStatus(true);
                        $this->em->persist($userEvaluation);
                        $this->em->flush();
                        $dado['staTus'] = 'S';
                    }
                }
                // $processamento = new \SoapVar(array(
                //     'numEmp' => $dados[$key]['numEmp'],
                //     'tipCol' => $dados[$key]['tipCol'],
                //     'numCad' => $dados[$key]['numCad'],
                //     'codEvn' => $dados[$key]['codEvn'],
                //     'status' => $dados[$key]['status'],
                // ), SOAP_ENC_OBJECT);
                // array_push($processamentoArray, $processamento);
                $itemXML.= "<processamentos>";
                $itemXML.= "<numEmp>".$dado['numEmp']."</numEmp>";
                $itemXML.= "<tipCol>".$dado['tipCol']."</tipCol>";
                $itemXML.= "<numCad>".$dado['numCad']."</numCad>";
                $itemXML.= "<codEvn>".$dado['codEvn']."</codEvn>";
                $itemXML.= "<staTus>".$dado['staTus']."</staTus>";
                if ($menRet!="") {
                    $itemXML.= "<menRet>".$menRet."</menRet>";
                }
                $itemXML.= "</processamentos>";
            }
            $xml = "<result>";
            $xml.= $itemXML;
            // $xml.= "<codRet>0</codRet>";
            $xml.= "<menRet></menRet>";
            $xml.= "</result>";

            return new \SoapVar($xml, XSD_ANYXML);
            // return new \SoapVar(array(
            //         'codRet' => 0,
            //         'menRet' => "Ok",
            //         'processamentos' => $processamentoArray,
            // ), SOAP_ENC_OBJECT);
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 2,
            //     'evnLMS' => null,
            //     'menRet' => "Error",
            // ), SOAP_ENC_OBJECT);

            $xml = "<result>";
            $xml.= "<codRet>2</codRet>";
            $xml.= "<evnLMS></evnLMS>";
            $xml.= "<menRet>".$error."</menRet>";
            $xml.= "</result>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    /**
    * Cadastro de Eventos LMS
    * @param String $token
    * @param Integer $encryption
    * @param array $parameters
    * @return array
     */
    public function ConsultaParticipante($token, $encryption, $parameters)
    {

        //$this->logger->error(json_encode($parameters, true));
        $this->APIValidate($token);

        try {
            //$params = $this->xmlToarray($parameters);
            $params = $this->xmlToarray($parameters);

            if ($params['codOpe'] == 1 || $params['codOpe'] == 2) {
                $matriculados = array();
                $inscriptionRepository = $this->em->getRepository('AppBundle:Inscription');
                $inscriptions = $inscriptionRepository->getInscriptionByUserEvent($params['codEvn']);
                $itemXML = "";
                foreach ($inscriptions as $inscription) {
                    $client = $this->em->getRepository('AppBundle:Client')->find($inscription->getUser()->getId());
                    // $matriculado = new \SoapVar(array(
                    //     'codEvn' => $inscription->getCourse()->getIdevent(),
                    //     'numEmp' => $client->getNumEmp(),
                    //     'tipCol' => $client->getTipCol(),
                    //     'numCad' => $client->getNumCad(),
                    //     'codPes' => $client->getCodPes(),
                    //     'sitCua' => $inscription->getInscriptionStatus()->getId()
                    // ), SOAP_ENC_OBJECT);
                    // array_push($matriculados, $matriculado);

                    $itemXML.= "<matriculados>";
                    $itemXML.= "<codEvn>".$inscription->getCourse()->getCodeevent()."</codEvn>";
                    $itemXML.= "<numEmp>".$client->getNumEnterprise()."</numEmp>";
                    $itemXML.= "<tipCol>".$client->getTipColaborador()."</tipCol>";
                    $itemXML.= "<numCad>".$client->getMatColaborador()."</numCad>";
                    $itemXML.= "<codPes>".$client->getCodPes()."</codPes>";
                    $itemXML.= "<sitCua>".$inscription->getInscriptionStatus()->getId()."</sitCua>";
                    $itemXML.= "</matriculados>";
                }

                $menRet = ($params['codOpe'] == 1) ? 'Consulta Colaborador Matriculado' : 'Consulta Matriculados no Evento' ;

                // $response = array(
                //     'codRet' => 1,
                //     'menRet' => $menRet,
                //     'matriculados' => $matriculados
                // );
                //
                // return new \SoapVar($response, SOAP_ENC_OBJECT);

                $xml = "<result>";
                $xml.= $itemXML;
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>".$menRet."</menRet>";
                $xml.= "</result>";

                return new \SoapVar($xml, XSD_ANYXML);
            } elseif ($params['codOpe'] == 3 || $params['codOpe'] == 4) {
                $notas = array();

                $clients = null;
                if(array_key_exists('numCad', $params) && array_key_exists('numEmp', $params)){
                    if($params['numCad'] == '0'){
                        $clients = $this->em->getRepository('AppBundle:Client')->findBy(array(
                            'num_enterprise' => $params['numEmp']
                        ));
                    }else{
                        $clients = $this->em->getRepository('AppBundle:Client')->findBy(array(
                            'mat_colaborador' => $params['numCad'],
                            'num_enterprise' => $params['numEmp']
                        ));
                    }
                }

                $course = $this->em->getRepository('AppBundle:Course')->findOneBy(array(
                    'codeevent' =>  $params['codEvn']
                ));

                $itemXML = "";
                if ($clients == null && $course!=null) {
                    $userEvaluationRepository = $this->em->getRepository('AppBundle:UserEvaluation');
                    $userEvaluations = $userEvaluationRepository->getEvaluationUserEvent(null, $params['codEvn'], 500);
                    foreach ($userEvaluations as $userEvaluation) {
                        $client = $this->em->getRepository('AppBundle:Client')->find($userEvaluation->getUser()->getId());

                        $totalEvaluations = 0;
                        $totalEvaluationsGrade = 0;
                        $valid = true;
                        $fezAvaliacao = true;
                        if ($client != null) {
                            foreach ($course->getModules() as $module) {
                                if (count($module->getEvaluations())>0) {
                                    $totalEvaluations++;
                                    $evaluation = $module->getEvaluations()->get(0);

                                    $userEvaluations = $this->em->getRepository('AppBundle:UserEvaluation')->findBy(array(
                                        "user" => $client,
                                        "evaluation" => $evaluation,
                                    ));
                                    if (count($userEvaluations)>0) {
                                        $nota = $this->em->getRepository('AppBundle:UserEvaluation')->getMelhoresNotas($client, null, $evaluation);
                                        foreach ($nota as $value) {
                                            $totalEvaluationsGrade+=$value["betterGrade"];
                                            if ($value["betterGrade"] < $evaluation->getMinimumGrade()) {
                                                $valid = false;
                                            }
                                        }
                                    } else {
                                        $fezAvaliacao = false;
                                    }
                                }
                            }
                            if ($userEvaluation->getEvaluation()) {
                                $percentual = $totalEvaluationsGrade/$totalEvaluations;
                                $percentual = number_format($percentual);
                            } else {
                                $percentual = $userEvaluation->getGrade();
                            }

                            $frequencia = 100;

                            $user = $this->em->getRepository('UserBundle:User')->find($client->getId());
                            $inscription = $this->em->getRepository('AppBundle:Inscription')->getLastInscriptionByUserForApi($user, $course);
                            //Obtem a data final do curso
                            if ($userEvaluation->getDtUpdate()!=null) {
                                $datTer = $userEvaluation->getDtUpdate()->format('Y-m-d');
                            } else {
                                $datTer = "";
                            }
                            // if($inscription->getDtEnd()!=null){
                            //     $datTer = $inscription->getDtEnd()->format('Y-m-d');
                            // }else{
                            //     $datTer = "";
                            // }

                            if ($inscription->getDtCreation()!=null) {
                                $dataIni = $inscription->getDtCreation()->format('Y-m-d');
                            } elseif ($inscription->getDtBegin()!=null) {
                                $dataIni = $inscription->getDtBegin()->format('Y-m-d');
                            } else {
                                $dataIni = "";
                            }
                            if ($fezAvaliacao) {
                                $itemXML.= "<notas>";
                                $itemXML.= "<codEvn>".$inscription->getCourse()->getCodeevent()."</codEvn>";
                                $itemXML.= "<numEmp>".$client->getNumEnterprise()."</numEmp>";
                                $itemXML.= "<tipCol>".$client->getTipColaborador()."</tipCol>";
                                $itemXML.= "<numCad>".$client->getMatColaborador()."</numCad>";
                                $itemXML.= "<codPes>".$client->getCodPes()."</codPes>";
                                $itemXML.= "<sitCua>".$inscription->getInscriptionStatus()->getId()."</sitCua>";
                                $itemXML.= "<notCua>".$percentual."</notCua>";
                                $itemXML.= "<freCua>".$frequencia."</freCua>";
                                $itemXML.= "<datIni>".$dataIni."</datIni>";
                                $itemXML.= "<datTer>".$datTer."</datTer>";
                                $itemXML.= "</notas>";
                            }
                        }
                    }
                } else {
                    foreach ($clients as $client) {
                        $totalQuestions = $this->em->getRepository('AppBundle:Question')->questionsForCourseUser($client, $course);

                        $totalEvaluations = 0;
                        $totalEvaluationsGrade = 0;
    
                        $valid = true;
                        $fezAvaliacao = true;
                        if ($client != null) {
                            foreach ($course->getModules() as $module) {
                                if (count($module->getEvaluations())>0) {
                                    $totalEvaluations++;
                                    $evaluation = $module->getEvaluations()->get(0);
                                    // $user = $this->em->getRepository('UserBundle:User')->find($client->getId());
                                    $userEvaluations = $this->em->getRepository('AppBundle:UserEvaluation')->findBy(array(
                                        "user" => $client,
                                        "evaluation" => $evaluation,
                                    ));
                                    $nota = $this->em->getRepository('AppBundle:UserEvaluation')->getMelhoresNotas($client, null, $evaluation);
                                    if (count($userEvaluations)>0) {
                                        foreach ($nota as $value) {
                                            $totalEvaluationsGrade+=$value["betterGrade"];
                                            if ($value["betterGrade"] < $evaluation->getMinimumGrade()) {
                                                $valid = false;
                                            }
                                        }
                                    } else {
                                        $fezAvaliacao  = false;
                                    }
                                }
                            }
    
                            $percentual = $totalEvaluationsGrade/$totalEvaluations;
                            $percentual = number_format($percentual);
                            $frequencia = 100;
    
                            $user = $this->em->getRepository('UserBundle:User')->find($client->getId());
                            $inscription = $this->em->getRepository('AppBundle:Inscription')->getLastInscriptionByUserForApi($user, $course);
                            if($inscription!=null){
                                //Obtem a data final do curso
                                if($inscription->getDtEnd()!=null){
                                    $datTer = $inscription->getDtEnd()->format('Y-m-d');
                                }else{
                                    $datTer = "";
                                }
                                if($inscription->getDtCreation()!=null){
                                    $dataIni = $inscription->getDtCreation()->format('Y-m-d');
                                }else if($inscription->getDtBegin()!=null){
                                    $dataIni = $inscription->getDtBegin()->format('Y-m-d');
                                }else{
                                    $dataIni = "";
                                }
                                if($fezAvaliacao){
                                    $itemXML.= "<notas>";
                                    $itemXML.= "<codEvn>".$inscription->getCourse()->getCodeevent()."</codEvn>";
                                    $itemXML.= "<numEmp>".$client->getNumEnterprise()."</numEmp>";
                                    $itemXML.= "<tipCol>".$client->getTipColaborador()."</tipCol>";
                                    $itemXML.= "<numCad>".$client->getMatColaborador()."</numCad>";
                                    $itemXML.= "<codPes>".$client->getCodPes()."</codPes>";
                                    $itemXML.= "<sitCua>".$inscription->getInscriptionStatus()->getId()."</sitCua>";
                                    $itemXML.= "<notCua>".$percentual."</notCua>";
                                    $itemXML.= "<freCua>".$frequencia."</freCua>";
                                    $itemXML.= "<datIni>".$dataIni."</datIni>";
                                    $itemXML.= "<datTer>".$datTer."</datTer>";
                                    $itemXML.= "</notas>";
                                }
                            }
                        }
                    }
                }

                $menRet = ($params['codOpe'] == 3) ? "Consulta Nota/Frequencia Colaborador" : "Consulta Nota/Frequencia Evento" ;

                $xml = "<result>";
                $xml.= $itemXML;
                $xml.= "<codRet>1</codRet>";
                $xml.= "<menRet>".$menRet."</menRet>";
                $xml.= "</result>";

                return new \SoapVar($xml, XSD_ANYXML);
            } else {

                // $result = array(
                //     'codRet' => 2,
                //     'evnLMS' => "",
                //     'menRet' => "Error",
                // );
                //
                // return new \SoapVar($result, SOAP_ENC_OBJECT);

                $xml = "<result>";
                $xml.= "<codRet>2</codRet>";
                $xml.= "<menRet>Invalid operation " . $params['codOpe']."</menRet>";
                $xml.= "<evnLMS></evnLMS>";
                $xml.= "</result>";

                return new \SoapVar($xml, XSD_ANYXML);
            }
        } catch (Exception $e) {
            $error = utf8_encode($e);
            // $response = array(
            //     'codRet' => 2,
            //     'evnLMS' => null,
            //     'menRet' => "Error",
            // );
            //
            // return new \SoapVar($response, SOAP_ENC_OBJECT);

            $xml = "<result>";
            $xml.= "<codRet>2</codRet>";
            $xml.= "<menRet>".$error."</menRet>";
            $xml.= "<evnLMS></evnLMS>";
            $xml.= "</result>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    /**
     * Consulta de Cursos LMS
     * @param String $token
     * @param String $categoria
     * @return \SoapBundle\Services\cursos
     */
    public function ConsultaCurso($token, $categoria)
    {
        $this->APIValidate($token);
        try {
            // $category = $this->em->getRepository('AppBundle:Category')->findOneByName($categoria);
            $categories = $this->em->getRepository('AppBundle:Category')->findForSearch(trim($categoria));
            // $courses = $this->em->getRepository('AppBundle:Course')->findBy(array(
            //     'category' => $category,
            //     'active' => true
            // ));
            $courses = $this->em->getRepository('AppBundle:Course')->findForApi($categories);

            $itemXML = "";
            if(empty($categories) || empty($courses)){
                $xml = "<result>";
                $xml.='<menRet>Não foi encontrado nenhum curso ativo para a categoria "'.$categoria.'"</menRet>';
                $xml.= "</result>";
            }else{
                // foreach ($courses as $course) {
                //     $itemXML.= "<curso type='tns:curso'>";
                //     $itemXML.= '<id type="xs:integer">'.$course->getId().'</id>';
                //     $itemXML.= '<nome type="xs:string">'.$course->getTitle().'</nome>';
                //     $itemXML.= "</curso>";
                // }
                // $xml.="<cursos type='tns:cursos'>
                // ".$itemXML."</cursos>";

                /**
                 * Use an ArrayObject instead of a plain array.
                 */
                $return_array = new \ArrayObject();

                foreach ($courses as $course) {

                    // Build a basic return object.
                    $curso = new \SoapBundle\Services\curso();
                    $curso->nome = $course->getTitle();
                    $curso->id = $course->getId();

                    /**
                     * Encode each array element with SoapVar.  Parameter 5 is the name of the
                     * XML element you want to use.  This only seems to work within
                     * an ArrayObject.
                     */
                    $curso = new \SoapVar($curso, SOAP_ENC_OBJECT, "curso", null, 'curso');

                    $return_array->append($curso);
                }
                $return_array = new \SoapVar($return_array, SOAP_ENC_OBJECT, "cursos", null, 'cursos');
                return $return_array;
            }
            return new \SoapVar($xml, XSD_ANYXML);
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            $xml = "<result>";
            $xml.= "<codRet>1</codRet>";
            $xml.= "<menRet>".$error."</menRet>";
            $xml.= "</result>";
            return new \SoapVar($xml, XSD_ANYXML);
        }
    }
}

class cursos {
    /** @var \SoapBundle\Services\curso[] */
    public $curso;
}
class curso {
    public $id;
    public $nome;
}