<?php

namespace SoapBundle\Services;

use Doctrine\ORM\EntityManager;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use AppBundle\Entity\Course;

class StackOverFlowerService
{
  private $em;
  private $course;

  public function __construct(EntityManager $em)
  {
    $this->em = $em;
  }

  public function newStack($name)
  {
    $course = new Course();
    $course->setName($name);

    $this->em->persist($course);
    $this->em->flush();

    return "ok";
  }

  public function getList()
  {
    $courses = $this->em->getRepository("AppBundle:Course")->findAll();

    $encoders = array(new XmlEncoder(), new JsonEncoder());
    //$normalizers = array(new ObjectNormalizer());
    $normalizer = new ObjectNormalizer(null);
    $normalizer->setIgnoredAttributes(array('company', 'origin'));
    $normalizer->setCircularReferenceHandler(function ($object) {
        return $object->getId();
    });

    $serializer = new Serializer(array($normalizer), $encoders);

    return $serializer->serialize($courses, 'json');
  }

  public function edit($id, $name)
  {
    $course = $this->em->getRepository("AppBundle:Course")->findOneById($id);

    $course->setName($name);

    $this->em->persist($course);
    $this->em->flush();

    return "ok";
  }

  public function delete($id)
  {
    $course = $this->em->getRepository("AppBundle:Course")->findOneById($id);

    $this->em->remove($course);
    $this->em->flush();

    return "ok";
  }
}
