<?php

namespace SoapBundle\Services;

use Doctrine\ORM\EntityManager;
use AppBundle\Entity\Client;
use AppBundle\Entity\UserStatus;
use AppBundle\Entity\JobRole;
use AppBundle\Entity\Sector;
use AppBundle\Entity\Management;
use JMS\Serializer\SerializerBuilder;

class UserService
{
    protected $container;
    protected $em;
    protected $logger;
    protected $token = "token";
    protected $soapUser;
    protected $soapPassword;
    protected $salt = "cb5qhiIGEdvx%wc66d9iLfnn9qsJ*mZc";


    /**
     * ObtÃ©m o token de permissÃ£o
     * @param String $user
     * @param String $password
     * @return array
     */
    public function GetToken($user, $password)
    {
        $this->APIValidateUser($user, $password);
        // $response = array(
        //     'token' => md5(date('h').$this->salt),
        // );
        $xml = '<return>
            <token>' . md5(date('h') . $this->salt) . '</token>
            </return>';
        return new \SoapVar($xml, XSD_ANYXML);
    }

    private function APIValidateUser($user, $password)
    {
        if ($user != $this->soapUser || $password != $this->soapPassword) {
            throw new \SoapFault("Server", "Incorrect user/password");
        }
    }

    private function APIValidate($token)
    {
        $myToken = md5(date('h') . $this->salt);
        if ($token != $myToken) {
            throw new \SoapFault("Server", "Incorrect token ");
        }
    }

    public function __construct($container, EntityManager $em, $logger, $api_user, $api_password)
    {
        $this->container = $container;
        $this->em = $em;
        $this->logger = $logger;
        $this->soapUser = $api_user;
        $this->soapPassword = $api_password;
    }

    /**
     * Listar usuarios
     * @param String $token
     * @param String $numCad
     * @param String $grupo
     * @param String $cpf
     * @return array
     */
    public function Listar($token, $numCad, $grupo, $cpf)
    {
        $this->APIValidate($token);
        try {
            // if ($numCad == null || $numCad == "") {
            //     // $userList = $this->em->getRepository('AppBundle:Client')->findByEnabled(1);
            //     $userList = $this->em->getRepository('AppBundle:Client')->findForApi();
            // } else {
            //     $userList = $this->em->getRepository('AppBundle:Client')->findBy(array(
            //         'numCad' => (int)preg_replace("/[^\d]+/", "", $numCad)
            //     ));
            // }

            //TODO: FIND USERGROUP
            $userGroups = $this->findUserGroup($grupo, true);
            // $this->logger->error(json_encode($userGroups));
            foreach ($userGroups as $key => $userGroup) {
                $this->logger->error($userGroup);
            }

            $numCad = $numCad ? (int)preg_replace("/[^\d]+/", "", $numCad) : null;
            // $userList = $this->em->getRepository('AppBundle:Client')->findForApi($numCad, $grupo, $cpf);
            $userList = $this->em->getRepository('AppBundle:Client')->findForApi($numCad, $userGroups, $cpf);

            $itemXML = "";
            foreach ($userList as $key => $item) {
                // $this->logger->error($item->getId());

                if ($item->getLastLogin() != null) {
                    $lastLogin = $item->getLastLogin()->format('Y-m-d');
                } else {
                    $lastLogin = "";
                }
                if ($item->getSuperior() != null) {
                    $numCadSuperior = $item->getSuperior()->getMatColaborador();
                } else {
                    $numCadSuperior = "";
                }
                if ($item->getUserStatus() != null) {
                    $userStatus = $item->getUserStatus()->getName();
                } else {
                    $userStatus = "";
                }
                if ($item->getJobRole() != null) {
                    $jobRole = $item->getJobRole()->getName();
                } else {
                    $jobRole = "";
                }
                if ($item->getSector() != null) {
                    $sector = $item->getSector()->getName();
                } else {
                    $sector = "";
                }
                if ($item->getUserStatus()) {
                    $sitAfastamento = $item->getUserStatus()->getName();
                } else {
                    $sitAfastamento = "";
                }


                $itemXML .= '<item>';
                $itemXML .= '<id>' . $item->getId() . '</id>';
                $itemXML .= '<nome>' . trim($item->getFirstName()) . ' ' . trim($item->getLastName()) . '</nome>';
                // $itemXML .= '<user_status>'.$userStatus.'</user_status>';
                $itemXML .= '<job_role>' . $jobRole . '</job_role>';
                $itemXML .= '<sector>' . $sector . '</sector>';
                // $itemXML .= '<nomeLocalidade>'.$sector.'</nomeLocalidade>';
                $itemXML .= '<email>' . $item->getEmail() . '</email>';
                $itemXML .= '<enabled>' . ($item->isEnabled() ? "Active" : "Inactive") . '</enabled>';
                $itemXML .= '<cpf>' . $item->getCpf() . '</cpf>';
                $itemXML .= '<situacaoAfastamento>' . $sitAfastamento . '</situacaoAfastamento>';
                $itemXML .= '<grupo>' . ($item->getUsergroup() ? $item->getUsergroup()->getItemGroup() : "" ) . '</grupo>';
                // $itemXML .= '<tip_colaborador>' . $item->getTipColaborador() . '</tip_colaborador>';

                // if ($lastLogin != "") {
                $itemXML .= '<last_login>' . $lastLogin . '</last_login>';
                // }
                $itemXML .= '<first_name>' . trim($item->getFirstName()) . '</first_name>';
                $itemXML .= '<last_name>' . trim($item->getLastName()) . '</last_name>';
                // if ($item->getCelphone() != "") {
                $itemXML .= '<celphone>' . $item->getCelphone() . '</celphone>';
                // }
                // if ($item->getPhone() != "") {
                $itemXML .= '<phone>' . $item->getPhone() . '</phone>';
                // }
                $itemXML .= '<login>' . $item->getLogin() . '</login>';
                // if ($item->getManagement()) {
                $itemXML .= '<gestao>' . $item->getManagement() . '</gestao>';
                // }
                $itemXML .= '<numEmp>' . $item->getNumEnterprise() . '</numEmp>';
                $itemXML .= '<tipCol>' . $item->getTipColaborador() . '</tipCol>';
                $itemXML .= '<numCad>' . $item->getMatColaborador() . '</numCad>';
                // if ($numCadSuperior != "") {
                $itemXML .= '<numCadSuperior>' . $numCadSuperior . '</numCadSuperior>';
                // }
                $itemXML .= '<codPes>' . ($item->getCodPes() ? $item->getCodPes() : '0') . '</codPes>';
                $itemXML .= '</item>';
            }

            $msgResponse = '';
            $codRet = 0;
            if (count($userList) == 0) {
                $msgResponse = 'Não foi encontrado nenhum registro.';

                $userSearch = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                    'mat_colaborador' => $numCad
                ));

                if ($userSearch and $userSearch->getUserStatus()) {
                    $status = $userSearch->getUserStatus();
                    if ($status->getCode() == 7 || $status->getCode() == 71 || $status->getCode() == 77) {
                        $codRet = 1;
                        $msgResponse = 'Usuário encontra-se demitido';
                    }
                }
            }

            $xml = "<return>";
            $xml .= "<codRet>".$codRet."</codRet>";
            $xml .= "<menRet>" . $msgResponse . "</menRet>";
            $xml .= "<usuarios>" . $itemXML . "</usuarios>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        } catch (\Exception $e) {
            $this->logger->error(json_encode($e));
            $error = utf8_encode($e);
            /*return new \SoapVar(array(
                'codRet' => 1,
                'menRet' => "Error",
                'erroExecucao' => $error
            ), SOAP_ENC_OBJECT);*/
            $xml = "<return>";
            $xml .= "<codRet>1</codRet>";
            $xml .= "<menRet>" . $error . "</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    public function responseErroSoap($msgResponse)
    {
        $xml = "<return>";
        $xml .= "<codRet>1</codRet>";
        $xml .= $msgResponse;
        $xml .= "</return>";

        return new \SoapVar($xml, XSD_ANYXML);
    }

    public function validateFieldParameterAPI($field, $item)
    {
        if (!array_key_exists($field, $item) || (array_key_exists($field, $item) && empty($item[$field]))) {
            return false;
        }

        return true;
    }

    public function responseErrorFieldEmpty($field)
    {
        $msgResponse = "<menRet>Campo ".$field." vazio, favor preencher</menRet>";
        return $this->responseErroSoap($msgResponse);
    }

    /**
     * Criar usuario
     * @param String $token
     * @param array $parameters
     * @return array
     */
    public function Criar($token, $parameters)
    {
        $this->APIValidate($token);
        try {
            $repository = $this->em->getRepository('AppBundle:Client');
            $this->logger->error("CHAMADA SOAP - criar user");
            $this->logger->error(print_r($parameters, true));
            $item = $this->xmlToarray($parameters);
            $client = null;

            $msgResponse = "";

            if (array_key_exists('grupo', $item) && isset($item['grupo'])) {
                $groupUser = $this->transformGroupUser($item['grupo']);

                if (in_array("CLAUSU.PERFIL_SECRETARIA_MEDICO", $groupUser) && in_array("OUTSYS_PORTALATENDENTE.PERFIL_COMUM", $groupUser)) {
                    if (!array_key_exists('cpf', $item) || (array_key_exists('cpf', $item) && empty($item['cpf']))) {
                        $msgResponse = "<menRet>Campo CPF vazio, favor preencher</menRet>";

                        return $this->responseErroSoap($msgResponse);
                    }
                } else {
                    // $this->validateCommomUser($item);
                    if(!$this->validateCommomUser($item)){
                        $msgResponse = "<menRet>Usuário ja cadastrado com o numCad " . $item['numCad'] . " e numEmp " . $item['numEmp'] . "</menRet>";
                        return $this->responseErroSoap($msgResponse);
                    }
                }
            } else {
                // $this->validateCommomUser($item);
                if(!$this->validateCommomUser($item)){
                    $msgResponse = "<menRet>Usuário ja cadastrado com o numCad " . $item['numCad'] . " e numEmp " . $item['numEmp'] . "</menRet>";
                    return $this->responseErroSoap($msgResponse);
                }
            }
            
            $client = new Client();

            $client->setEmail($this->getIndexArray('email', $item));
            if ($client->getEmail()=="") {
                $client->setEmail($item['numCad']."_".$item['numEmp']."_"."sem_email@unimedbh.com.br");
            }
            if (!$this->validUsernameEmail($client)) {
                $client->setEmail($item['numCad']."_".$item['numEmp']."_".$client->getEmail());
                if (!$this->validUsernameEmail($client)) {
                    $client->setEmail(rand()."_".$item['numCad']."_".$item['numEmp']."_".$client->getEmail());
                }
            }

            if (array_key_exists('job_role', $item) && isset($item['job_role'])) {
                $jobRole = $this->em->getRepository('AppBundle:JobRole')->findOneByName($item['job_role']);
                if ($jobRole == null) {
                    $jobRole = new JobRole();
                    $jobRole->setName($item['job_role']);
                    $this->em->persist($jobRole);
                }
                $client->setJobRole($jobRole);
            }
            if (array_key_exists('sector', $item) && isset($item['sector'])) {
                $sector = $this->em->getRepository('AppBundle:Sector')->findOneByName($item['sector']);
                if ($sector == null) {
                    $sector = new Sector();
                    $sector->setName($item['sector']);
                    $this->em->persist($sector);
                }
                $client->setSector($sector);
            }
            if (array_key_exists("gestao", $item)) {
                if ($item['gestao'] != null && $item['gestao'] != "") {
                    $management = $this->em->getRepository('AppBundle:Management')->findOneByName($item['gestao']);
                    if ($management == null) {
                        $management = new Management();
                        $management->setName($item['gestao']);
                        $this->em->persist($management);
                    }
                    $client->setManagement($management);
                }
            }
            $client->setUsername($client->getEmail());
            if (array_key_exists("login", $item)) {
                $client->setLogin($item['login']);
            }

            if (array_key_exists('enabled', $item) && isset($item['enabled'])) {
                $enabled = strtoupper($item['enabled']) == "ACTIVE" ? true : false;
                $client->setEnabled($enabled);
            }

            $client->setFirstName($this->getIndexArray('first_name', $item));
            $client->setLastName($this->getIndexArray('last_name', $item));
            $client->setCelphone($this->getIndexArray('celphone', $item));
            $client->setPhone($this->getIndexArray('phone', $item));
            $client->setRoles(array(
                "ROLE_USER"
            ));
            $client->setNumEnterprise($this->getIndexArray('numEmp', $item));
            $client->setTipColaborador($this->getIndexArray('tipCol', $item));

            if (array_key_exists('numCad', $item) && isset($item['numCad'])) {
                if (!empty($item['numCad']) || (is_numeric($item['numCad']) && $item['numCad'] == 0)) {
                    $numCad = array_key_exists('numCad', $item) ? (int)preg_replace("/[^\d]+/", "", $item['numCad']) : '';
                    $client->setMatColaborador($numCad);
                }
            }

            $client->setCodPes($this->getIndexArray('codPes', $item));
            if (empty($client->getCodPes())) {
                $client->setCodPes(0);
            }
            $client->setPhoto($this->getIndexArray('photo', $item));

            $superior = null;
            if (array_key_exists('numCadSuperior', $item) && isset($item['numCadSuperior']) && !empty(($item['numCadSuperior']))) {
                $superior = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                    'mat_colaborador' => (int)preg_replace("/[^\d]+/", "", $item['numCadSuperior']),
                    "num_enterprise" => 1
                ));
            }

            if ($superior) {
                $client->setSuperior($superior);
            }

            if (array_key_exists('situacaoAfastamento', $item) && isset($item['situacaoAfastamento'])) {
                $userStatus = $this->em->getRepository('AppBundle:UserStatus')->findOneByCode($item['situacaoAfastamento']);
                if (!$userStatus) {
                    $userStatus = $this->em->getRepository('AppBundle:UserStatus')->findOneByCode(0);
                }
                $client->setUserStatus($userStatus);
            }

            if (array_key_exists('cpf', $item)) {
                $client->setCpf($item['cpf']);
            }
            if (array_key_exists('grupo', $item) && isset($item['grupo'])) {
                $grupo = $this->findUserGroup($item['grupo']);
                if($grupo){
                    $client->setUsergroup($grupo);
                    $client->setAccessGranted($grupo->getActive());
                }
            }

            // if (array_key_exists('grupo', $item)) {
            //     $client->setGroup($item['grupo']);
            // }

            $encoder = $this->container->get('security.encoder_factory')->getEncoder($client);
            $new_pwd_encoded = rand();
            $client->setPassword($new_pwd_encoded);

            $this->em->persist($client);
            $this->em->flush();

            $xml = "<return>";
            $xml .= "<codRet>0</codRet>";
            $xml .= "<menRet>Registro criado com sucesso</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            $xml = "<return>";
            $xml .= "<codRet>1</codRet>";
            $xml .= "<menRet>" . $error . "</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    protected function findUserGroup($consultaGrupo, $returnArray = false)
    {
        $userGroupArray = array();
        $arrayConsultaGrupo = explode(",",$consultaGrupo);
        // array_walk($arrayConsultaGrupo, 'normalize_group');
        $arrayConsultaGrupo = array_map('trim', $arrayConsultaGrupo);
        $arrayConsultaGrupo = array_map('strtoupper', $arrayConsultaGrupo);
        $repositoryUserGroup = $this->em->getRepository("AppBundle:UserGroup");
        $userGroups = $repositoryUserGroup->findAll();
        foreach ($userGroups as $userGroup) {
            $grupo = strpos($userGroup->getItemGroup(), ',') ? explode(",",$userGroup->getItemGroup()) : strtoupper(trim($userGroup->getItemGroup()));
            if (is_array($grupo)) {
                $match = 0;
                foreach($grupo as $item) {
                    $grupoString = strtoupper(trim($item));                   
                    if (in_array($grupoString, $arrayConsultaGrupo)) {
                        $match++;
                    } 
                }
                if($match == count($grupo)){
                    if($returnArray){
                        array_push($userGroupArray, $userGroup);
                    }else{
                        return $userGroup;
                    }
                }
            }else{
                if (in_array($grupo, $arrayConsultaGrupo)) {
                    if($returnArray){
                        array_push($userGroupArray, $userGroup);
                    }else{
                        return $userGroup;
                    }
                }
            }
        }
        if($returnArray){
            return $userGroupArray;
        }      
    }


    public function normalize_group(&$item1, $key)
    {
        $item1 = strtoupper(trim($item1));
    }

    protected function validateCommomUser($item)
    {
        if (!$this->validateFieldParameterAPI('numCad', $item)) {
            return $this->responseErrorFieldEmpty('numCad');
        }

        if (!$this->validateFieldParameterAPI('numEmp', $item)) {
            return $this->responseErrorFieldEmpty('numEmp');
        }

        if (isset($item['numCad']) && isset($item['numEmp'])) {
            $numCad = empty($item['numCad']) ? null: $item['numCad'];
            $numEmp = empty($item['numEmp']) ? null: $item['numEmp'];
            $repository = $this->em->getRepository('AppBundle:Client');
            $client = $repository->findByNumCadAndNumEmp($numCad, $numEmp);
            $this->logger->error($client);
            if ($client) {
                // $msgResponse = "<menRet>Usuário ja cadastrado com o numCad " . $item['numCad'] . " e numEmp " . $item['numEmp'] . "</menRet>";
                // return $this->responseErroSoap($msgResponse);
                return false;
            }
            return true;
        }
    }

    /**
     * Desativar usuario
     * @param String $token
     * @param String $numCad
     * @return array
     */
    public function Desativar($token, $numCad)
    {
        $this->APIValidate($token);
        try {
            $client = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                'mat_colaborador' => (int)preg_replace("/[^\d]+/", "", $numCad),
            ));
            if ($client == null) {
                // return new \SoapVar(array(
                //     'codRet' => 1,
                //     'menRet' => "Usuario nao encontrado."
                // ), SOAP_ENC_OBJECT);

                $xml = "<return>";
                $xml .= "<codRet>1</codRet>";
                $xml .= "<menRet>Usuário não encontrado</menRet>";
                $xml .= "</return>";

                return new \SoapVar($xml, XSD_ANYXML);
            }

            $userStatus = $this->em->getRepository('AppBundle:UserStatus')->findOneByName("INACTIVE");
            if ($userStatus == null) {
                $userStatus = $this->em->getRepository('AppBundle:UserStatus')->findOneByName("INATIVO");
            } else {
                $client->setUserStatus($userStatus);
            }

            $client->setEnabled(false);
            $this->em->persist($client);
            $this->em->flush();

            // return new \SoapVar(array(
            //     'codRet' => 0,
            //     'menRet' => "Registro desativado com sucesso."
            // ), SOAP_ENC_OBJECT);
            $xml = "<return>";
            $xml .= "<codRet>0</codRet>";
            $xml .= "<menRet>Registro desativado com sucesso</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'menRet' => "Error",
            //     'erroExecucao' => $error
            // ), SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml .= "<codRet>1</codRet>";
            $xml .= "<menRet>" . $error . "</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    public function transformGroupUser($group)
    {
        $func = function ($item) {
            return strtoupper(trim($item));
        };

        $groupDataList = explode(",", $group);
        $result = array_map($func, $groupDataList);

        return $result;
    }

    /**
     * Atualizar usuario
     * @param String $token
     * @param array $parameters
     * @return array
     */
    public function Editar($token, $parameters)
    {
        $this->APIValidate($token);
        try {
            $this->logger->error("CHAMADA SOAP - editar user");
            $this->logger->error(print_r($parameters, true));
            $item = $this->xmlToarray($parameters);

            // verificar se usuario tem grupo preenchido (caso tenha e seja secretária procurar pelo cpf)
            // senao vai procurar um usuario normal com numCad e numEmp

            $checkGroupUserSecretariaFlag = false;

            if (array_key_exists('grupo', $item) && isset($item['grupo'])) {
                $groupUser = $this->transformGroupUser($item['grupo']);

                if (in_array("CLAUSU.PERFIL_SECRETARIA_MEDICO", $groupUser) && in_array("OUTSYS_PORTALATENDENTE.PERFIL_COMUM", $groupUser)) {
                    if (!array_key_exists('cpf', $item) || (array_key_exists('cpf', $item) && empty($item['cpf']))) {
                        $msgResponse = "<menRet>Campo CPF vazio, favor preencher</menRet>";

                        return $this->responseErroSoap($msgResponse);
                    }

                    $checkGroupUserSecretariaFlag = true;
                }
            }

            $client = null;
            // Verifica se usuario é secretária
            if ($checkGroupUserSecretariaFlag) {
                $secretariaUserGroup = $this->em->getRepository('AppBundle:UserGroup')->findSecretaria();
                $client = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                    'cpf' => $item['cpf'],
                    'usergroup'  => $secretariaUserGroup              
                ));

                if (!$client) {
                    $msgResponse = "<menRet>Usuário não cadastrado com o cpf " . $item['cpf'] . "</menRet>";
                    return $this->responseErroSoap($msgResponse);
                }
            } else {
                if (isset($item['numCad']) && isset($item['numEmp'])) {
                    $numCad = empty($item['numCad']) ? null: $item['numCad'] ;
                    $numEmp = empty($item['numEmp']) ? null: $item['numEmp'] ;
                    $repository = $this->em->getRepository('AppBundle:Client');
                    $client = $repository->findByNumCadAndNumEmp($numCad, $numEmp);

                    if (!$client) {
                        $msgResponse = "<menRet>Usuário não cadastrado com o numCad " . $item['numCad'] . " e numEmp " . $item['numEmp'] . "</menRet>";
                        return $this->responseErroSoap($msgResponse);
                    }
                } else {
                    if (!$client) {
                        $msgResponse = "<menRet>Usuário não cadastrado com o numCad " . $item['numCad'] . " e numEmp " . $item['numEmp'] . "</menRet>";
                        return $this->responseErroSoap($msgResponse);
                    }
                }
            }

            if ($client->getEmail() != $item['email']) {
                // $clientDB = $this->em->getRepository('AppBundle:Client')->findOneByEmail($item['email']);
                // if($clientDB != null && $clientDB->getId() != $client->getId()){
                //     $xml = "<return>";
                //     $xml .= "<codRet>1</codRet>";
                //     $xml .= "<menRet>O usuário numCad " . $clientDB->getMatColaborador() . " já está cadastrado com o email " . $item['email'] . "</menRet>";
                //     $xml .= "</return>";

                //     return new \SoapVar($xml, XSD_ANYXML);
                // }
                // $client->setEmail($item['email']);
                // if ($client->getEmail()=="") {
                //     $client->setEmail($item['numCad']."_".$item['numEmp']."_"."sem_email@unimedbh.com.br");
                // }
                // // if (!$this->validUsernameEmail($client)) {
                // //     // $uniqueString = md5(uniqid(rand(), true));
                // //     // $client->setEmail($uniqueString."_".$item['numCad']."_".$item['numEmp']);
                // //     $client->setEmail($item['numCad']."_".$item['numEmp']."_".$client->getEmail());
                // // }
                // $client->setUsername($client->getEmail());
                $client->setEmail($item['email']);
                if ($client->getEmail()=="") {
                    $client->setEmail($item['numCad']."_".$item['numEmp']."_"."sem_email@unimedbh.com.br");
                }
                if (!$this->validUsernameEmail($client)) {
                    $client->setEmail($item['numCad']."_".$item['numEmp']."_".$client->getEmail());
                    if (!$this->validUsernameEmail($client)) {
                        $client->setEmail(rand()."_".$item['numCad']."_".$item['numEmp']."_".$client->getEmail());
                    }
                }
                $client->setUsername($client->getEmail());

            }

            $this->logger->error("ITEM - situacaoAfastamento");
            $this->logger->error($item['situacaoAfastamento']);

            if (array_key_exists('situacaoAfastamento', $item) && isset($item['situacaoAfastamento'])) {
                $userStatus = $this->em->getRepository('AppBundle:UserStatus')->findOneByCode($item['situacaoAfastamento']);
                if (!$userStatus) {
                    $userStatus = $this->em->getRepository('AppBundle:UserStatus')->findOneByCode(0);
                }

                // $this->logger->error("ITEM - userStatus");
                // $this->logger->error($userStatus->getCode());
                $client->setUserStatus($userStatus);
            }
            if (array_key_exists('job_role', $item) && isset($item['job_role'])) {
                $jobRole = $this->em->getRepository('AppBundle:JobRole')->findOneByName($item['job_role']);
                if ($jobRole == null) {
                    $jobRole = new JobRole();
                    $jobRole->setName($item['job_role']);
                    $this->em->persist($jobRole);
                }
                $client->setJobRole($jobRole);
            }
            if (array_key_exists('sector', $item) && isset($item['sector'])) {
                $sector = $this->em->getRepository('AppBundle:Sector')->findOneByName($item['sector']);
                if ($sector == null) {
                    $sector = new Sector();
                    $sector->setName($item['sector']);
                    $this->em->persist($sector);
                }
                $client->setSector($sector);
            }
            if (array_key_exists('gestao', $item) && isset($item['gestao'])) {
                $management = $this->em->getRepository('AppBundle:Management')->findOneByName($item['gestao']);
                if ($management == null) {
                    $management = new Management();
                    $management->setName($item['gestao']);
                    $this->em->persist($management);
                }
                $client->setManagement($management);
            }
            if (array_key_exists("login", $item)) {
                $client->setLogin($item['login']);
            }

            if (array_key_exists('enabled', $item) && isset($item['enabled'])) {
                $enabled = strtoupper($item['enabled']) == "ACTIVE" ? true : false;
                $client->setEnabled($enabled);
            }

            $client->setFirstName($this->getIndexArray('first_name', $item));
            $client->setLastName($this->getIndexArray('last_name', $item));
            $client->setCelphone($this->getIndexArray('celphone', $item));
            $client->setPhone($this->getIndexArray('phone', $item));
            $client->setRoles(array("ROLE_USER"));

            $this->logger->error("CHAMADA SOAP - Teste");
            $this->logger->error($item['codPes']);

            $client->setNumEnterprise($item['numEmp'] != null ? $item['numEmp'] : null);
            $client->setTipColaborador($item['tipCol'] != null ? $item['tipCol'] : null);
            $client->setMatColaborador($item['numCad'] != null ? $item['numCad'] : null);
            $client->setCodPes($item['codPes'] != null ? $item['codPes'] : null);
            if ($client->getCodPes() == "") {
                $client->setCodPes(0);
            }
            $client->setPhoto($this->getIndexArray('photo', $item));

            if (array_key_exists('numCadSuperior', $item)) {
                $superior = $this->em->getRepository('AppBundle:Client')->findOneBy(array(
                    'mat_colaborador' => $item['numCadSuperior'],
                    "num_enterprise" => 1
                ));

                if ($superior) {
                    $client->setSuperior($superior);
                }
            }

            if (array_key_exists('cpf', $item)) {
                $client->setCpf($item['cpf']);
            }

            // if (array_key_exists('grupo', $item)) {
            //     $client->setGroup($item['grupo']);
            // }
            if (array_key_exists('grupo', $item) && isset($item['grupo'])) {
                $grupo = $this->findUserGroup($item['grupo']);
                if($grupo){
                    $client->setUsergroup($grupo);
                    // $client->setAccessGranted($grupo->getActive());
                }
            }

            $encoder = $this->container->get('security.encoder_factory')->getEncoder($client);
            $new_pwd_encoded = rand();
            $client->setPassword($new_pwd_encoded);

            $this->em->persist($client);
            $this->em->flush();
            // return new \SoapVar(array(
            //     'codRet' => 0,
            //     'numCad' => $client->getNumCad(),
            //     'menRet' => "Registro atualizado com sucesso."
            // ), SOAP_ENC_OBJECT);


            $xml = "<return>";
            $xml .= "<codRet>0</codRet>";
            // $xml .= "<numCad>" . $client->getNumCad() . "</numCad>";
            // $xml .= '<grupo>' . $client->getUsergroup() . '</grupo>';
            $xml .= "<menRet>Registro atualizado com sucesso</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
            // } else {
            //     // return new \SoapVar(array(
            //     //     'codRet' => 1,
            //     //     'menRet' => "Usuario com o email/login ja cadastrado"
            //     // ), SOAP_ENC_OBJECT);
            //
            //     $xml = "<return>";
            //     $xml.= "<codRet>1</codRet>";
            //     $xml.= "<menRet>Usuario com o email/login ja cadastrado</menRet>";
            //     $xml.= "</return>";
            //
            //     return new \SoapVar($xml, XSD_ANYXML);
            // }
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            // return new \SoapVar(array(
            //     'codRet' => 1,
            //     'menRet' => "Error",
            //     'erroExecucao' => $error
            // ), SOAP_ENC_OBJECT);

            $xml = "<return>";
            $xml .= "<codRet>1</codRet>";
            $xml .= "<menRet>" . $error . "</menRet>";
            $xml .= "</return>";

            return new \SoapVar($xml, XSD_ANYXML);
        }
    }

    public function getIndexArray($index, $list)
    {
        if (array_key_exists($index, $list)) {
            return empty($list[$index]) ? null : $list[$index];
        } else {
            return null;
        }
    }

    private function xmlToarray($xmlObject, $out = array())
    {
        foreach ((array)$xmlObject as $index => $node) {
            $out[$index] = (is_object($node)) ? $this->xmlToarray($node) : $node;
        }

        return $out;
    }

    private function validUsernameEmail($entity)
    {
        $flag = $this->em->getRepository('UserBundle:User')->getUserByNameAndUsername($entity);

        return $flag;
    }
}
