CHANGELOG for 2.8.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.8 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.8.0...v2.8.1

* 2.8.36 (2018-03-05)

 * bug #26368 [WebProfilerBundle] Fix Debug toolbar breaks app (xkobal)

* 2.8.35 (2018-03-01)

 * bug #26338 [Debug] Keep previous errors of Error instances (Philipp91)
 * bug #26312 [Routing] Don't throw 405 when scheme requirement doesn't match (nicolas-grekas)
 * bug #26298 Fix ArrayInput::toString() for InputArgument::IS_ARRAY args (maximium)
 * bug #26236 [PropertyInfo] ReflectionExtractor: give a chance to other extractors if no properties (dunglas)
 * bug #25557 [WebProfilerBundle] add a way to limit ajax request (Simperfit)
 * bug #26228 [HttpFoundation] Fix missing "throw" in JsonResponse (nicolas-grekas)
 * bug #26211 [Console] Suppress warning from sapi_windows_vt100_support (adawolfa)
 * bug #26156 Fixes #26136: Avoid emitting warning in hasParameterOption() (greg-1-anderson)
 * bug #26183 [DI] Add null check for removeChild (changmin.keum)
 * bug #26173 [Security] fix accessing request values (xabbuh)
 * bug #26159 created validator.tl.xlf for Form/Translations (ergiegonzaga)
 * bug #26100 [Routing] Throw 405 instead of 404 when redirect is not possible (nicolas-grekas)
 * bug #26040 [Process] Check PHP_BINDIR before $PATH in PhpExecutableFinder (nicolas-grekas)
 * bug #26012 Exit as late as possible (greg0ire)
 * bug #26111 [Security] fix merge of 2.7 into 2.8 + add test case (dmaicher)
 * bug #25893 [Console] Fix hasParameterOption / getParameterOption when used with multiple flags (greg-1-anderson)
 * bug #25940 [Form] keep the context when validating forms (xabbuh)
 * bug #25373 Use the PCRE_DOLLAR_ENDONLY modifier in route regexes (mpdude)
 * bug #26010 [CssSelector] For AND operator, the left operand should have parentheses, not only right operand (Arnaud CHASSEUX)
 * bug #25971 [Debug] Fix bad registration of exception handler, leading to mem leak (nicolas-grekas)
 * bug #25962 [Routing] Fix trailing slash redirection for non-safe verbs (nicolas-grekas)
 * bug #25948 [Form] Fixed empty data on expanded ChoiceType and FileType (HeahDude)
 * bug #25972 support sapi_windows_vt100_support for php 7.2+ (jhdxr)
 * bug #25744 [TwigBridge] Allow label translation to be safe (MatTheCat)

* 2.8.34 (2018-01-29)

 * bug #25922 [HttpFoundation] Use the correct syntax for session gc based on Pdo driver (tanasecosminromeo)
 * bug #25933 Disable CSP header on exception pages only in debug (ostrolucky)
 * bug #25926 [Form] Fixed Button::setParent() when already submitted (HeahDude)
 * bug #25927 [Form] Fixed submitting disabled buttons (HeahDude)
 * bug #25891 [DependencyInjection] allow null values for root nodes in YAML configs (xabbuh)
 * bug #25848 [Validator] add missing parent isset and add test (Simperfit)
 * bug #25861 do not conflict with egulias/email-validator 2.0+ (xabbuh)
 * bug #25851 [Validator] Conflict with egulias/email-validator 2.0 (emodric)
 * bug #25837 [SecurityBundle] Don't register in memory users as services (chalasr)
 * bug #25835 [HttpKernel] DebugHandlersListener should always replace the existing exception handler (nicolas-grekas)
 * bug #25829 [Debug] Always decorate existing exception handlers to deal with fatal errors (nicolas-grekas)
 * bug #25824 Fixing a bug where the dump() function depended on bundle ordering (weaverryan)
 * bug #25789  Enableable ArrayNodeDefinition is disabled for empty configuration (kejwmen)
 * bug #25816 Problem in phar see mergerequest #25579 (betzholz)
 * bug #25781 [Form] Disallow transform dates beyond the year 9999 (curry684)
 * bug #25812 Copied NO language files to the new NB locale (derrabus)
 * bug #25801 [Router] Skip anonymous classes when loading annotated routes (pierredup)
 * bug #25657 [Security] Fix fatal error on non string username (chalasr)
 * bug #25799 Fixed Request::__toString ignoring cookies (Toflar)
 * bug #25755 [Debug] prevent infinite loop with faulty exception handlers (nicolas-grekas)
 * bug #25771 [Validator] 19 digits VISA card numbers are valid (xabbuh)
 * bug #25751 [FrameworkBundle] Add the missing `enabled` session attribute (sroze)
 * bug #25750 [HttpKernel] Turn bad hosts into 400 instead of 500 (nicolas-grekas)
 * bug #25490 [Serializer] Fixed throwing exception with option JSON_PARTIAL_OUTPUT_ON_ERROR (diversantvlz)
 * bug #25709 Tweaked some styles in the profiler tables (javiereguiluz)
 * feature #25669 [Security] Fail gracefully if the security token cannot be unserialized from the session (thewilkybarkid)

* 2.8.33 (2018-01-05)

 * bug #25532 [HttpKernel] Disable CSP header on exception pages (ostrolucky)
 * bug #25491 [Routing] Use the default host even if context is empty (sroze)
 * bug #25662 Dumper shouldn't use html format for phpdbg / cli-server (jhoff)
 * bug #25529 [Validator] Fix access to root object when using composite constraint (ostrolucky)
 * bug #25430 Fixes for Oracle in PdoSessionHandler (elislenio)
 * bug #25599 Add application/ld+json format associated to json (vincentchalamon)
 * bug #25407 [Console] Commands with an alias should not be recognized as ambiguous (Simperfit)
 * bug #25521 [Console] fix a bug when you are passing a default value and passing -n would output the index (Simperfit)
 * bug #25489 [FrameworkBundle] remove esi/ssi renderers if inactive (dmaicher)
 * bug #25427 Preserve percent-encoding in URLs when performing redirects in the UrlMatcher (mpdude)
 * bug #25480 [FrameworkBundle] add missing validation options to XSD file (xabbuh)
 * bug #25487 [Console] Fix a bug when passing a letter that could be an alias (Simperfit)
 * bug #25233 [TwigBridge][Form] Fix hidden currency element with Bootstrap 3 theme (julienfalque)
 * bug #25408 [Debug] Fix catching fatal errors in case of nested error handlers (nicolas-grekas)
 * bug #25330 [HttpFoundation] Support 0 bit netmask in IPv6 (`::/0`) (stephank)
 * bug #25410 [HttpKernel] Fix logging of post-terminate errors/exceptions (nicolas-grekas)
 * bug #25323 [ExpressionLanguage] throw an SyntaxError instead of an undefined index notice (Simperfit)

* 2.8.32 (2017-12-04)

 * bug #25278 Fix for missing whitespace control modifier in form layout (kubawerlos)
 * bug #25236 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25258 [link] Prevent warnings when running link with 2.7 (dunglas)
 * bug #24750 [Validator] ExpressionValidator should use OBJECT_TO_STRING  (Simperfit)
 * bug #25182 [HttpFoundation] AutExpireFlashBag should not clear new flashes (Simperfit, sroze)
 * bug #25152 [Form] Don't rely on `Symfony\Component\HttpFoundation\File\File` if http-foundation isn't in FileType (issei-m)
 * bug #24987 [Console] Fix global console flag when used in chain (Simperfit)
 * bug #25043 [Yaml] added ability for substitute aliases when mapping is on single line (Michał Strzelecki, xabbuh)
 * bug #25102 [Form] Fixed ContextErrorException in FileType (chihiro-adachi)
 * bug #25130 [DI] Fix handling of inlined definitions by ContainerBuilder (nicolas-grekas)
 * bug #25072 [Bridge/PhpUnit] Remove trailing "\n" from ClockMock::microtime(false) (joky)
 * bug #24956 Fix ambiguous pattern (weltling)

* 2.8.31 (2017-11-16)

 * security #24995 Validate redirect targets using the session cookie domain (nicolas-grekas)
 * security #24994 Prevent bundle readers from breaking out of paths (xabbuh)
 * security #24993 Ensure that submitted data are uploaded files (xabbuh)
 * security #24992 Namespace generated CSRF tokens depending of the current scheme (dunglas)

* 2.8.30 (2017-11-13)

 * bug #24952 [HttpFoundation] Fix session-related BC break (nicolas-grekas, sroze)
 * bug #24929 [Console] Fix traversable autocomplete values (ro0NL)

* 2.8.29 (2017-11-10)

 * bug #24888 [FrameworkBundle] Specifically inject the debug dispatcher in the collector (ogizanagi)
 * bug #24909 [Intl] Update ICU data to 60.1 (jakzal)
 * bug #24906 [Bridge/ProxyManager] Remove direct reference to value holder property (nicolas-grekas)
 * bug #24900 [Validator] Fix Costa Rica IBAN format (Bozhidar Hristov)
 * bug #24904 [Validator] Add Belarus IBAN format (Bozhidar Hristov)
 * bug #24531 [HttpFoundation] Fix forward-compat of NativeSessionStorage with PHP 7.2 (sroze)
 * bug #24665 Fix dump panel hidden when closing a dump (julienfalque)
 * bug #24814 [Intl] Make intl-data tests pass and save language aliases again (jakzal)
 * bug #24764 [HttpFoundation] add Early Hints to Reponse to fix test (Simperfit)
 * bug #24605 [FrameworkBundle] Do not load property_access.xml if the component isn't installed (ogizanagi)
 * bug #24606 [HttpFoundation] Fix FileBag issue with associative arrays (enumag)
 * bug #24660 Escape trailing \ in QuestionHelper autocompletion (kamazee)
 * bug #24644 [Security] Fixed auth provider authenticate() cannot return void (glye)
 * bug #24642 [Routing] Fix resource miss (dunglas)
 * bug #24608 Adding the Form default theme files to be warmed up in Twig's cache (weaverryan)
 * bug #24626 streamed response should return $this (DQNEO)
 * bug #24589 Username and password in basic auth are allowed to contain '.' (Richard Quadling)
 * bug #24566 Fixed unsetting from loosely equal keys OrderedHashMap (maryo)
 * bug #24570 [Debug] Fix same vendor detection in class loader (Jean-Beru)
 * bug #24563 [Serializer] ObjectNormalizer: throw if PropertyAccess isn't installed (dunglas)
 * bug #24571 [PropertyInfo] Add support for the iterable type (dunglas)
 * bug #24579 pdo session fix (mxp100)
 * bug #24536 [Security] Reject remember-me token if UserCheckerInterface::checkPostAuth() fails (kbond)
 * bug #24519 [Validator] [Twig] added magic method __isset()  to File Constraint class (loru88)
 * bug #24532 [DI] Fix possible incorrect php-code when dumped strings contains newlines (Strate)
 * bug #24502 [HttpFoundation] never match invalid IP addresses (xabbuh)
 * bug #24460 [Form] fix parsing invalid floating point numbers (xabbuh)
 * bug #24490 [HttpFoundation] Combine Cache-Control headers (c960657)
 * bug #23711 Fix support for PHP 7.2 (Simperfit, nicolas-grekas)
 * bug #24494 [HttpFoundation] Add missing session.lazy_write config option (nicolas-grekas)
 * bug #24434 [Form] Use for=ID on radio/checkbox label. (Nyholm)
 * bug #24455 [Console] Escape command usage (sroze)

* 2.8.28 (2017-10-05)

 * bug #24448 [Session] fix MongoDb session handler to gc all expired sessions (Tobion)
 * bug #24417 [Yaml] parse references on merge keys (xabbuh)
 * bug #24421 [Config] Fix dumped files invalidation by OPCache (nicolas-grekas)
 * bug #23980 Tests and fix for issue in array model data in EntityType field with multiple=true (stoccc)
 * bug #22586 [Form] Fixed PercentToLocalizedStringTransformer to accept both comma and dot as decimal separator, if possible (aaa2000)
 * bug #24157 [Intl] Fixed support of Locale::getFallback (lyrixx)
 * bug #24198 [HttpFoundation] Fix file upload multiple with no files (enumag)
 * bug #24036 [Form] Fix precision of MoneyToLocalizedStringTransformer's divisions and multiplications (Rubinum)
 * bug #24367 PdoSessionHandler: fix advisory lock for pgsql (Tobion)
 * bug #24243 HttpCache does not consider ESI resources in HEAD requests (mpdude)
 * bug #24304 [FrameworkBundle] Fix Routing\DelegatingLoader (nicolas-grekas)
 * bug #24219 [Console] Preserving line breaks between sentences according to the exception message (yceruto)
 * bug #23722 [Form] Fixed GroupSequence with "constraints" option (HeahDude)
 * bug #22321 [Filesystem] Fixed makePathRelative (ausi)
 * bug #23473 [Filesystem] mirror - fix copying content with same name as source/target. (gitlost)
 * bug #24162 [WebProfilerBundle] fixed TemplateManager when using Twig 2 without compat interfaces (fabpot)
 * bug #24141 [DomCrawler] Fix conversion to int on GetPhpFiles (MaraBlaga)
 * bug #23853 Filtering empty uuids in ORMQueryBuilderLoader. (mlazovla)
 * bug #24101 [Security] Fix exception when use_referer option is true and referer is not set or empty (linniksa)
 * bug #24105 [Filesystem] check permissions if dump target dir is missing (xabbuh)
 * bug #24115 [FrameworkBundle] Get KERNEL_DIR through $_ENV too for KernelTestCase (yceruto)
 * bug #24041 [ExpressionLanguage] throws an exception on calling uncallable method (fmata)
 * bug #24096 Fix ArrayInput::toString() for VALUE_IS_ARRAY options/args (chalasr)
 * bug #23730 Fixed the escaping of back slashes and << in console output (javiereguiluz)

* 2.8.27 (2017-08-28)

 * bug #23989 [Debug] Remove false-positive check in DebugClassLoader (nicolas-grekas)
 * bug #23982 [VarDumper] Strengthen dumped JS (nicolas-grekas)
 * bug #23925 [Validator] Fix use of GroupSequenceProvider in child classes (linniksa)
 * bug #23945 [Validator] Fix Greek translation (azhurb)
 * bug #23909 [Console] Initialize lazily to render exceptions properly (nicolas-grekas)
 * bug #23856 [DI] Fix dumping abstract with YamlDumper (nicolas-grekas)
 * bug #23752 Ignore memcached missing key error on session destroy (jderusse)
 * bug #23658 [HttpFoundation] Generate safe fallback filename for wrongly encoded filename (xelaris)
 * bug #23783 Avoid infinite loops when profiler data is malformed (javiereguiluz)
 * bug #23729 [Bridge\ProxyManager] Dont call __destruct() on non-instantiated services (nicolas-grekas)

* 2.8.26 (2017-08-01)

 * bug #22244 [Console] Fix passing options with defaultCommand (Jakub Sacha)
 * bug #23684 [Debug] Missing escape in debug output (c960657)
 * bug #23662 [VarDumper] Adapt to php 7.2 changes (nicolas-grekas)
 * bug #23649 [Form][TwigBridge] Don't render _method in form_rest() for a child form (fmarchalemisys)
 * bug #23023 [DoctrineBridge][PropertyInfo] Added support for Doctrine Embeddables (vudaltsov)
 * bug #23619 [Validator] Fix IbanValidator for ukrainian IBANs (paroe)
 * bug #23238 [Security] ensure the 'route' index is set before attempting to use it (gsdevme)
 * bug #23330 [WebProfilerBundle] Fix full sized dump hovering in toolbar (ogizanagi)
 * bug #23580 Fix login redirect when referer contains a query string (fabpot)
 * bug #23574 [VarDumper] Move locale sniffing to dump() time (nicolas-grekas)

* 2.8.25 (2017-07-17)

 * security #23507 [Security] validate empty passwords again (xabbuh)
 * bug #23526 [HttpFoundation] Set meta refresh time to 0 in RedirectResponse content (jnvsor)
 * bug #23540 Disable inlining deprecated services (alekitto)
 * bug #23468 [DI] Handle root namespace in service definitions (ro0NL)
 * bug #23256 [Security] Fix authentication.failure event not dispatched on AccountStatusException (chalasr)
 * bug #23461 Use rawurlencode() to transform the Cookie into a string (javiereguiluz)
 * bug #23459 [TwigBundle] allow to configure custom formats in XML configs (xabbuh)
 * bug #23460 Don't display the Symfony debug toolbar when printing the page (javiereguiluz)
 * bug #23261 Fixed absolute url generation for query strings and hash urls (alexander-schranz)
 * bug #23398 [Filesystem] Dont copy perms when origin is remote (nicolas-grekas)

* 2.8.24 (2017-07-05)

 * bug #23378 [FrameworkBundle] Do not remove files from assets dir (1ed)

* 2.8.23 (2017-07-04)

 * bug #23341 [DoctrineBridge][Security][Validator] do not validate empty values (xabbuh)
 * bug #23274 Display a better error design when the toolbar cannot be displayed (yceruto)
 * bug #23333 [PropertyAccess] Fix TypeError discard (dunglas)
 * bug #23345 [Console] fix description of INF default values (xabbuh)
 * bug #23279 Don't call count on non countable object (pierredup)
 * bug #23283 [TwigBundle] add back exception check (xabbuh)
 * bug #23268 Show exception is checked twice in ExceptionController of twig (gmponos)
 * bug #23266 Display a better error message when the toolbar cannot be displayed (javiereguiluz)
 * bug #23271 [FrameworkBundle] allow SSI fragments configuration in XML files (xabbuh)
 * bug #23254 [Form][TwigBridge] render hidden _method field in form_rest() (xabbuh)
 * bug #23250 [Translation] return fallback locales whenever possible (xabbuh)
 * bug #23240 [Console] Fix catching exception type in QuestionHelper (voronkovich)
 * bug #23229 [WebProfilerBundle] Eliminate line wrap on count column (routing) (e-moe)
 * bug #22732 [Security] fix switch user _exit without having current token (dmaicher)
 * bug #22730 [FrameworkBundle] Sessions: configurable "use_strict_mode" option for NativeSessionStorage (MacDada)
 * bug #23195 [FrameworkBundle] [Command] Clean bundle directory, fixes #23177 (NicolasPion)
 * bug #23052 [TwigBundle] Add Content-Type header for exception response (rchoquet)
 * bug #23199 Reset redirectCount when throwing exception (hvanoch)
 * bug #23186 [TwigBundle] Move template.xml loading to a compiler pass (ogizanagi)
 * bug #23130 Keep s-maxage when expiry and validation are used in combination (mpdude)
 * bug #23129 Fix two edge cases in ResponseCacheStrategy (mpdude)
 * feature #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #23057 [Translation][FrameworkBundle] Fix resource loading order inconsistency reported in #23034 (mpdude)
 * bug #23092 [Filesystem] added workaround in Filesystem::rename for PHP bug (VolCh)
 * bug #23128 [HttpFoundation] fix for Support for new 7.1 session options (vincentaubert)
 * bug #23176 [VarDumper] fixes (nicolas-grekas)
 * bug #22953 #22839 - changed debug toolbar dump section to relative and use full window width (mkurzeja)
 * bug #23086 [FrameworkBundle] Fix perf issue in CacheClearCommand::warmup() (nicolas-grekas)
 * bug #23098 Cache ipCheck (2.7) (gonzalovilaseca)
 * bug #23069 [SecurityBundle] Show unique Inherited roles in profile panel (yceruto)

* 2.8.22 (2017-06-07)

 * bug #23073 [TwigBridge] Fix namespaced classes (ogizanagi)
 * bug #22936 [Form] Mix attr option between guessed options and user options (yceruto)
 * bug #22988 [PropertyInfo][DoctrineBridge] The bigint Doctrine's type must be converted to string (dunglas)
 * bug #23014 Fix optional cache warmers are always instantiated whereas they should be lazy-loaded (romainneutron)
 * bug #23024 [EventDispatcher] Fix ContainerAwareEventDispatcher::hasListeners(null) (nicolas-grekas)
 * bug #22996 [Form] Fix \IntlDateFormatter timezone parameter usage to bypass PHP bug #66323 (romainneutron)
 * bug #22994 Harden the debugging of Twig filters and functions (stof)

* 2.8.21 (2017-05-29)

 * bug #22847 [Console] ChoiceQuestion must have choices (ro0NL)
 * bug #22900 [FrameworkBundle][Console] Fix the override of a command registered by the kernel (aaa2000)
 * bug #22910 [Filesystem] improve error handling in lock() (xabbuh)
 * bug #22718 [Console] Fixed different behaviour of key and value user inputs in multiple choice question (borNfreee)
 * bug #22901 Fix missing abstract key in XmlDumper (weaverryan)
 * bug #22817 [PhpUnitBridge] optional error handler arguments (xabbuh)
 * bug #22752 Improved how profiler errors are displayed on small screens (javiereguiluz)
 * bug #22647 [VarDumper] Fix dumping of non-nested stubs (nicolas-grekas)
 * bug #22584 [Security] Avoid unnecessary route lookup for empty logout path (ro0NL)
 * bug #22690 [Console] Fix errors not rethrown even if not handled by console.error listeners (chalasr)
 * bug #22669 [FrameworkBundle] AbstractConfigCommand: do not try registering bundles twice (ogizanagi)
 * bug #22676 [FrameworkBundle] Adding the extension XML (flug)

* 2.8.20 (2017-05-01)

 * bug #22550 Allow Upper Case property names in ObjectNormalizer (insekticid)
 * bug #22528 [Asset] Starting slash should indicate no basePath wanted (weaverryan)
 * bug #22541 [EventDispatcher] fix: unwrap listeners for correct info (dmaicher)
 * bug #22526 [Asset] Preventing the base path or absolute URL from being prefixed incorrectly (weaverryan)
 * bug #22523 [WebProfilerBundle] Fixed the flickering when loading complex profiler panels (javiereguiluz)
 * bug #22435 [Console] Fix dispatching throwables from ConsoleEvents::COMMAND (nicolas-grekas)
 * bug #22478 [Serializer] XmlEncoder: fix negative int and large numbers handling (dunglas)
 * bug #22424 [Debug] Set exit status to 255 on error (nicolas-grekas)
 * bug #22426 [PropertyInfo] Prevent returning int values in some cases (dunglas)
 * bug #22399  Prevent double registrations related to tag priorities (nicolas-grekas)
 * bug #22396 Prevent double registrations related to tag priorities (nicolas-grekas)
 * bug #22352 [HttpFoundation] Add `use_strict_mode` in validOptions for session (sstok)
 * bug #22351 [Yaml] don't keep internal state between parser runs (xabbuh)
 * bug #22307 [Debug] Fix php notice (enumag)
 * bug #22311 [DI] Fix second auto-registration (nicolas-grekas)
 * bug #22109 [Validator] check for empty host when calling checkdnsrr() (apetitpa)
 * bug #22280 [DI] Fix the xml schema (GuilhemN)
 * bug #22282 [DI] Prevent AutowirePass from triggering irrelevant deprecations (chalasr)
 * bug #22255 [Translation] avoid creating cache files for fallback locales. (aitboudad)
 * bug #22292 Fixes #22264 - add support for Chrome headless (redthor)

* 2.8.19 (2017-04-05)

 * bug #22265 Allow Upper Case property names (insekticid)
 * bug #22258 [DI] Autowiring and factories are incompatible with each others (nicolas-grekas)
 * bug #22254 [DI] Don't use auto-registered services to populate type-candidates (nicolas-grekas)
 * bug #22229 [ExpressionLanguage] Provide the expression in syntax errors (k0pernikus, stof)
 * bug #22251 [PropertyInfo] Support nullable array or collection (4rthem)
 * bug #22240 [DI] Fix fatal error at ContainerBuilder::compile() if config is not installed (chalasr)
 * bug #22140 [Form] Improve the exceptions when trying to get the data in a PRE_SET_DATA listener and the data has not already been set (fancyweb)
 * bug #22217 [Console] Fix table cell styling (ro0NL)
 * bug #22194 [Console] CommandTester: disable color support detection (julienfalque)
 * bug #22188 [Console] Revised exception rendering (ro0NL)
 * bug #22154 [WebProfilerBundle] Normalize whitespace in exceptions passed in headers (curry684)
 * bug #22142 [Console] Escape exception messages in renderException (chalasr)
 * bug #22172 Fix port usage in server:status command (alcaeus)
 * bug #22164 [Bridge\Doctrine] Fix change breaking doctrine-bundle test suite (nicolas-grekas)
 * bug #22133 [Filesystem] normalize paths before making them relative (xabbuh)
 * bug #22138 [HttpFoundation][bugfix] $bags should always be initialized (MacDada)
 * bug #21810 #21809 [SecurityBundle] bugfix: if security provider's name contains upper cases then container didn't compile (Antanas Arvasevicius)
 * bug #22123 [WebProfilerBundle] Fix for CSS attribute at Profiler Translation Page (e-moe)
 * bug #19778 [Security] Fixed roles serialization on token from user object (eko)
 * bug #22036 Set Date header in Response constructor already (mpdude)
 * bug #22022 [Validator] fix URL validator to detect non supported chars according to RFC 3986 (e-moe)
 * bug #21849 [HttpFoundation] Fix missing handling of for/host/proto info from "Forwarded" header (nicolas-grekas)
 * bug #21968 Fixed pathinfo calculation for requests starting with a question mark. (syzygymsu)
 * bug #22027 Revert "bug #21841 [Console] Do not squash input changes made from console.command event (chalasr)" (chalasr)
 * bug #21846 [HttpFoundation] Fix Request::getHost() when having several hosts in X_FORWARDED_HOST (nicolas-grekas)
 * bug #21208 [Validator] Add object handling of invalid constraints in Composite (SenseException)
 * bug #22044 [Serializer] [XML] Ignore Process Instruction (jordscream)
 * bug #22079 [HttpKernel] Fixed bug with purging of HTTPS URLs (ausi)
 * bug #21523 #20411 fix Yaml parsing for very long quoted strings (RichardBradley)
 * bug #22001 [Doctrine Bridge] fix priority for doctrine event listeners (dmaicher)
 * bug #21981 [Console] Use proper line endings in BufferedOutput (julienfalque)
 * bug #21976 [VarDumper] Add missing isset() checks in some casters (nicolas-grekas)
 * bug #21957 [Form] Choice type int values (BC Fix) (mcfedr)
 * bug #21923 [travis] Test with hhvm 3.18 (nicolas-grekas)
 * bug #21823 dumpFile(), preserve existing file permissions (chs2)
 * bug #21865 [Security] context listener: hardening user provider handling (xabbuh)
 * bug #21883 [HttpKernel] fix Kernel name when stored in a directory starting with a number (fabpot)

* 2.8.18 (2017-03-06)

 * bug #21841 [Console] Do not squash input changes made from console.command event (chalasr)
 * bug #21671 [Serializer] Xml encoder throws exception for valid data (gr1ev0us)
 * bug #21805 Provide less state in getRequestFormat (dawehner)
 * bug #21832 [Routing] Ignore hidden directories when loading routes from annotations (jakzal)
 * bug #21769 [Form] Improve rounding precision (foaly-nr1)
 * bug #21825 [PhpUnitBridge] disable global test listener when not registered (xabbuh)
 * bug #21267 [Form] Fix ChoiceType to ensure submitted data is not nested unnecessarily (issei-m)
 * bug #21731 Fix emacs link (rubenrua)
 * bug #21800  Fix issues reported by static analyze (romainneutron)
 * bug #21798 Revert "bug #21791 [SecurityBundle] only pass relevant user provider (xabbuh)" (xabbuh)
 * bug #21791 [SecurityBundle] only pass relevant user provider (xabbuh)
 * bug #21787 [PhpUnitBridge] do not register the test listener twice (xabbuh)
 * bug #21756 [Yaml] Stop replacing NULLs when merging (gadelat)
 * bug #21689 [WebServerBundle] fixed html attribute escape (Seb33300)
 * bug #21722 [ExpressionLanguage] Registering functions after calling evaluate(), compile() or parse() is not supported (maidmaid)
 * bug #21679 [SecurityBundle] fix priority ordering of security voters (xabbuh)
 * bug #21115 [Validator] do not guess getter method names (xabbuh)
 * bug #21670 [DependencyInjection] Fix autowiring types when there are more than 2 services colliding (GuilhemN)
 * bug #21665 [DependencyInjection] Fix autowiring collisions detection (nicolas-grekas, GuilhemN)
 * bug #21661 Fix Composer constraints (fabpot)
 * bug #21582 [HttpCache] purge both http and https from http cache (dbu)
 * bug #21637 [FrameworkBundle] remove translation data collector when not usable (xabbuh)
 * bug #21634 [VarDumper] Added missing persistent stream cast (lyrixx)
 * bug #21436 [DependencyInjection] check for circular refs caused by method calls (xabbuh)
 * bug #21400 [Serializer] fix upper camel case conversion (see #21399) (markusu49)
 * bug #21599 [Console][Table] fixed render when using multiple rowspans. (aitboudad)
 * bug #21613 [Process] Permit empty suffix on Windows (Bilge)
 * bug #21057 [DI] Auto register extension configuration classes as a resource (ro0NL)
 * bug #21592 [Validator] property constraints can be added in child classes (angelk, xabbuh)
 * bug #21458 [Config] Early return for DirectoryResource (robfrawley)
 * bug #21562 [DoctrineBridge] make sure that null can be the invalid value (xabbuh)
 * bug #21584 [WebProfilerBundle] Readd Symfony version status in the toolbar (wouterj)
 * bug #21557 [VarDumper] Improve dump of AMQP* Object (lyrixx)
 * bug #21542 [VarDumper] Fixed dumping of terminated generator (lyrixx)

* 2.8.17 (2017-02-06)

 * bug #20844 [Config] Fix checking cache for non existing meta file (hason)
 * bug #21063 [Form] Fixed DateType format option for single text widget (HeahDude)
 * bug #21430 Casting TableCell value to string. (jaydiablo)
 * bug #21359 [FrameworkBundle] fixed custom domain for translations in php templates (robinlehrmann)
 * bug #21485 [Process] Non ASCII characters disappearing during the escapeshellarg (GuillaumeVerdon)
 * bug #21370 [FrameworkBundle] Execute the PhpDocExtractor earlier (GuilhemN)
 * bug #21462 [BrowserKit] ignore invalid cookies expires date format (xabbuh)
 * bug #21438 [Console] Fix TableCell issues with decoration (ogizanagi)
 * bug #21431 [DoctrineBridge] always check for all fields to be mapped (xabbuh)
 * bug #21360 [PropertyAccess] Handle interfaces in the invalid argument exception (fancyweb)
 * bug #21403 [DI] Fix defaults overriding empty strings in AutowirePass (nicolas-grekas)
 * bug #21401 [Debug] Workaround "null" $context (nicolas-grekas)
 * bug #21333 [HttpKernel] Fix ArgumentValueResolver for arguments default null (chalasr)
 * bug #20871 [HttpKernel] Give higher priority to adding request formats (akeeman)
 * bug #21332 [PropertyInfo] Don't try to access a property thru a static method (dunglas)
 * bug #21331 [PropertyInfo] Exclude static methods form properties guessing (dunglas)
 * bug #21285 [TwigBundle] do not lose already set method calls (xabbuh)
 * bug #21279 #20411 fix Yaml parsing for very long quoted strings (RichardBradley)

* 2.8.16 (2017-01-12)

 * bug #21218 [Form] DateTimeToLocalizedStringTransformer does not use timezone when using date only (magnetik)
 * bug #21104 [FrameworkBundle] fix IPv6 address handling in server commands (xabbuh)
 * bug #20793 [Validator] Fix caching of constraints derived from non-serializable parents (uwej711)
 * bug #19586 [TwigBundle] Fix bug where namespaced paths don't take parent bundles in account (wesleylancel)
 * bug #21237 [FrameworkBundle] Fix relative paths used as cache keys (nicolas-grekas)
 * bug #21183 [Validator] respect groups when merging constraints (xabbuh)
 * bug #21179 [TwigBundle] Fixing regression in TwigEngine exception handling (Bertalan Attila)
 * bug #21220 [DI] Fix missing new line after private alias (ogizanagi)
 * bug #21211 Classloader tmpname (lyrixx)
 * bug #21205 [TwigBundle] fixed usage when Templating is not installed (fabpot)
 * bug #21155 [Validator] Check cascasdedGroups for being countable (scaytrase)
 * bug #21200 [Filesystem] Check that directory is writable after created it in dumpFile() (chalasr)
 * bug #21113 [FrameworkBundle][HttpKernel] Fix resources loading for bundles with custom structure (chalasr)
 * bug #21084 [Yaml] handle empty lines inside unindented collection (xabbuh)
 * bug #20925 [HttpFoundation] Validate/cast cookie expire time (ro0NL)
 * bug #21032 [SecurityBundle] Made collection of user provider unique when injecting them to the RemberMeService (lyrixx)
 * bug #21078 [Console] Escape default value when dumping help (lyrixx)
 * bug #21076 [Console] OS X Can't call cli_set_process_title php without superuser (ogizanagi)
 * bug #20900 [Console] Descriptors should use Helper::strlen (ogizanagi)
 * bug #21064 [Debug] Wrap call to ->log in a try catch block (lyrixx)
 * bug #21010 [Debug] UndefinedMethodFatalErrorHandler - Handle anonymous classes (SpacePossum)
 * bug #20859 Avoid warning in PHP 7.2 because of non-countable data (wouterj)
 * bug #21053 [Validator] override property constraints in child class (xabbuh)
 * bug #21034 [FrameworkBundle] Make TemplateController working without the Templating component (dunglas)
 * bug #20970 [Console] Fix question formatting using SymfonyStyle::ask() (chalasr, ogizanagi)
 * bug #20975 [Form] fix group sequence based validation (xabbuh)
 * bug #20599 [WebProfilerBundle] Display multiple HTTP headers in WDT (ro0NL)
 * bug #20799 [TwigBundle] do not try to register incomplete definitions (xabbuh)
 * bug #20961 [Validator] phpize default option values (xabbuh)
 * bug #20934 [FrameworkBundle] Fix PHP form templates on translatable attributes (ro0NL)
 * bug #20957 [FrameworkBundle] test for the Validator component to be present (xabbuh)
 * bug #20936 [DependencyInjection] Fix on-invalid attribute type in xsd (ogizanagi)
 * bug #20931 [VarDumper] Fix dumping by-ref variadics (nicolas-grekas)
 * bug #20734 [Security] AbstractVoter->supportsAttribute gives false positive if attribute is zero (0) (martynas-foodpanda)
 * bug #14082 [config] Fix issue when key removed and left value only (zerustech)
 * bug #20847 [Console] fixed BC issue with static closures (araines)

* 2.8.15 (2016-12-13)

 * bug #20714 [FrameworkBundle] Fix unresolved parameters from default configs in debug:config (chalasr)
 * bug #20442 [FrameworkBundle] Bundle commands are not available via find() (julienfalque)
 * bug #20840 [WebProfilerBundle] add dependency on Twig (xabbuh)
 * bug #20828 [Validator] Fix init of YamlFileLoader::$classes for empty files (nicolas-grekas)
 * bug #20539 Cast result to int before adding to it (alcaeus)
 * bug #20831 [Twig] Fix deprecations with Twig 1.29 (nicolas-grekas)
 * bug #20767 [Cache] Fix dumping SplDoublyLinkedList iter mode (nicolas-grekas)
 * bug #20736 [Console] fixed PHP7 Errors when not using Dispatcher (keradus)
 * bug #20755 [HttpKernel] Regression test for missing controller arguments (iltar)
 * bug #20418 [Form][DX] FileType "multiple" fixes (yceruto)
 * bug #19902 [DependencyInjection] PhpDumper.php: hasReference() shouldn't search references in lazy service. (antanas-arvasevicius)
 * bug #20704 [Console] Fix wrong handling of multiline arg/opt descriptions (ogizanagi)
 * bug #20712 [TwigBundle] Fix twig loader registered twice (ogizanagi)
 * bug #20716 [WebProfilerBundle] Fix dump block is unfairly restrained (ogizanagi)
 * bug #20671 [Config] ConfigCache::isFresh() should return false when unserialize() fails (nicolas-grekas)
 * bug #20676 [ClassLoader] Use only forward slashes in generated class map (nicolas-grekas)
 * bug #20664 [Validator] ensure the proper context for nested validations (xabbuh)
 * bug #20661 bug #20653 [WebProfilerBundle] Profiler includes ghost panels (jzawadzki)
 * bug #20374 [FrameworkBundle] Improve performance of ControllerNameParser (enumag)
 * bug #20474 [Routing] Fail properly when a route parameter name cannot be used as a PCRE subpattern name (fancyweb)
 * bug #20566 [DI] Initialize properties before method calls (ro0NL)
 * bug #20609 [DI] Fixed custom services definition BC break introduced in ec7e70fb… (kiler129)
 * bug #20598 [DI] Aliases should preserve the aliased invalid behavior (nicolas-grekas)
 * bug #20602 [HttpKernel] Revert BC breaking change of Request::isMethodSafe() (nicolas-grekas)
 * bug #20499 [Doctrine][Form] support large integers (xabbuh)
 * bug #20576 [Process] Do feat test before enabling TTY mode (nicolas-grekas)

* 2.8.14 (2016-11-21)

 * bug #20543 [DI] Fix error when trying to resolve a DefinitionDecorator (nicolas-grekas)
 * bug #20544 [PhpUnitBridge] Fix time-sensitive tests that use data providers (julienfalque)
 * bug #20484 bumped min version of Twig to 1.28 (fabpot)
 * bug #20519 [Debug] Remove GLOBALS from exception context to avoid endless recursion (Seldaek)
 * bug #20455 [ClassLoader] Fix ClassCollectionLoader inlining with __halt_compiler (giosh94mhz)
 * bug #20307 [Form] Fix Date\TimeType marked as invalid on request with single_text and zero seconds (LuisDeimos)
 * bug #20466 [Translation] fixed nested fallback catalogue  using multiple locales. (aitboudad)
 * bug #20465 [#18637][TranslationDebug] workaround for getFallbackLocales. (aitboudad)
 * bug #20440 [TwigBridge][TwigBundle][HttpKernel] prefer getSourceContext() over getSource() (xabbuh)
 * bug #20422 [Translation][fallback] add missing resources in parent catalogues. (aitboudad)
 * bug #20378 [Form] Fixed show float values as choice value in ChoiceType (yceruto)
 * bug #20294 Improved the design of the metrics in the profiler (javiereguiluz)
 * bug #20375 [HttpFoundation][Session] Fix memcache session handler (klandaika)
 * bug #20377 [Console] Fix infinite loop on missing input (chalasr)
 * bug #20372 [Console] simplified code (fabpot)
 * bug #20342 [Form] Fix UrlType transforms valid protocols (ogizanagi)
 * bug #20292 Enhance GAE compat by removing some realpath() (nicolas-grekas)
 * bug #20326 [VarDumper] Fix dumping Twig source in stack traces (nicolas-grekas)
 * bug #20321 Compatibility with Twig 1.27 (xkobal)

* 2.8.13 (2016-10-27)

 * bug #20289 Fix edge case with StreamedResponse where headers are sent twice (Nicofuma)
 * bug #20267 [DependencyInjection] A decorated service should not keep the autowiring types (chalasr)
 * bug #20278 [DependencyInjection] merge tags instead of completely replacing them (xabbuh)
 * bug #20271 Changes related to Twig 1.27 (fabpot)
 * bug #20252 Trim constant values in XmlFileLoader (lstrojny)
 * bug #20253 [TwigBridge] Use non-deprecated Twig_Node::getTemplateLine() (fabpot)
 * bug #20243 [WebProfilerBundle][btn-link] add `cursor: pointer` (aitboudad)
 * bug #20175 [VarDumper] Fix source links with latests Twig versions (nicolas-grekas)
 * bug #20235 [DomCrawler] Allow pipe (|) character in link tags when using Xpath expressions (klausi, nicolas-grekas)
 * bug #20224 [Twig] removed deprecations added in Twig 1.27 (fabpot)
 * bug #19478 fixed Filesystem:makePathRelative and added 2 more testcases (muhammedeminakbulut)
 * bug #20218 [HttpFoundation] no 304 response if method is not cacheable (xabbuh)
 * bug #20207 [DependencyInjection] move tags from decorated to decorating service (xabbuh)
 * bug #20205 [HttpCache] fix: do not cache OPTIONS request (dmaicher)
 * bug #20146 [Validator] Prevent infinite loop in PropertyMetadata (wesleylancel)
 * bug #20184 [FrameworkBundle] Convert null prefix to an empty string in translation:update (chalasr)
 * bug #20154 [PropertyInfo] Fix edge cases in ReflectionExtractor (nicolas-grekas)
 * bug #19725 [Security] $attributes can be anything, but RoleVoter assumes strings (Jonatan Männchen)
 * bug #20127 [HttpFoundation] JSONP callback validation (ro0NL)
 * bug #20163 add missing use statement (xabbuh)
 * bug #19961 [Console] Escape question text and default value in SymfonyStyle::ask() (chalasr)
 * bug #20141 [Console] Fix validation of empty values using SymfonyQuestionHelper::ask() (chalasr)
 * bug #20147 [FrameworkBundle] Alter container class instead of kernel name in cache:clear command (nicolas-grekas)

* 2.8.12 (2016-10-03)

 * bug #20102 [Validator] Url validator not validating hosts ending in a number (gwkunze)
 * bug #20132 Use "more entropy" option for uniqid() (javiereguiluz)
 * bug #20122 [Validator] Reset constraint options (ro0NL)
 * bug #20116 fixed AddConstraintValidatorsPass config (fabpot)
 * bug #20078 Fix #19943 Make sure to process each interface metadata only once (lemoinem)
 * bug #20080 [Form] compound forms without children should be considered rendered implicitly (backbone87)
 * bug #20087 [VarDumper] Fix PHP 7.1 compat (nicolas-grekas)
 * bug #20086 [VarDumper] Fix PHP 7.1 compat (nicolas-grekas)
 * bug #20077 [Process] silent file operation to avoid open basedir issues (xabbuh)
 * bug #20079 fixed Twig support for 1.26 and 2.0 (fabpot)
 * bug #20051 Fix indexBy type extraction (lemoinem)
 * bug #19951 [Finder] Trim trailing directory slash in ExcludeDirectoryFilterIterator (ro0NL)
 * bug #20018 [VarDumper] Fix test (nicolas-grekas)
 * bug #20011 Use UUID for error codes for Form validator. (Koc)
 * bug #20010 [DX] Fixed regression when exception message swallowed when logging it. (Koc)
 * bug #19983 [TwigBridge] removed Twig null nodes (deprecated as of Twig 1.25) (fabpot)
 * bug #19946 [Console] Fix parsing optionnal options with empty value in argv (chalasr)
 * bug #19636 [Finder] no PHP warning on empty directory iteration (ggottwald)
 * bug #19923 [bugfix] [Console] Set `Input::$interactive` to `false` when command is executed with `--quiet` as verbosity level (phansys)
 * bug #19811 Fixed the nullable support for php 7.1 and below (2.7, 2.8, 3.0) (iltar)
 * bug #19853 [PropertyInfo] Make ReflectionExtractor compatible with ReflectionType changes in PHP 7.1 (teohhanhui)
 * bug #19904 [Form] Fixed collapsed ChoiceType options attributes (HeahDude)
 * bug #19908 [Config] Handle open_basedir restrictions in FileLocator (Nicofuma)
 * bug #19924 [DoctrineBridge][PropertyInfo] Treat Doctrine decimal type as string (teohhanhui)
 * bug #19932 Fixed bad merge (GrahamCampbell)
 * bug #19922 [Yaml][TwigBridge] Use JSON_UNESCAPED_SLASHES for lint commands output (chalasr)
 * bug #19928 [Validator] Update IpValidatorTest data set with a valid reserved IP (jakzal)
 * bug #19813 [Console] fixed PHP7 Errors are now handled and converted to Exceptions (fonsecas72)
 * bug #19879 [Form] Incorrect timezone with DateTimeLocalizedStringTransformer (mbeccati)
 * bug #19878 Fix translation:update command count (tgalopin)

* 2.8.11 (2016-09-07)

 * bug #19859 [ClassLoader] Fix ClassCollectionLoader inlining with declare(strict_types=1) (nicolas-grekas)
 * bug #19780 [FrameworkBundle] Incorrect line break in exception message (500 debug page) (pedroresende)
 * bug #19595 [form] lazy trans `post_max_size_message`. (aitboudad)
 * bug #19870 [DI] Fix setting synthetic services on ContainerBuilder (nicolas-grekas)
 * bug #19848 Revert "minor #19689 [DI] Cleanup array_key_exists (ro0NL)" (nicolas-grekas)
 * bug #19842 [FrameworkBundle] Check for class existence before is_subclass_of (chalasr)
 * bug #19827 [BrowserKit] Fix cookie expiration on 32 bit systems (jameshalsall)

* 2.8.10 (2016-09-02)

 * bug #19786 Update profiler's layout to use flexbox (javiereguiluz)
 * bug #19794 [VarDumper] Various minor fixes & cleanups (nicolas-grekas)
 * bug #19751 Fixes the calendar in constructor to handle null (wakqasahmed)
 * bug #19388 [Validator][GroupSequence] fixed GroupSequence validation ignores PropetyMetadata of parent classes (Sandro Hopf)
 * bug #19601 [FrameworkBundle] Added friendly exception when constraint validator class does not exist (yceruto)
 * bug #19580 [Validator] fixed duplicate constraints with parent class interfaces (dmaicher)
 * bug #19647 [Debug] Swap dumper services at bootstrap (lyrixx)
 * bug #19685 [DI] Include dynamic services in alternatives (ro0NL)
 * bug #19702 [Debug][HttpKernel][VarDumper] Prepare for committed 7.2 changes (aka "small-bc-breaks") (nicolas-grekas)
 * bug #19704 [DependencyInjection] PhpDumper::isFrozen inconsistency (allflame)
 * bug #19643 [DependencyInjection] Fix service autowiring inheritance (chalasr)
 * bug #19667 [SecurityBundle] Add missing deprecation notice for form_login.intention (ro0NL)
 * bug #19666 Verify explicitly that the request IP is a valid IPv4 address (nesk)
 * bug #19660 Disable CLI color for Windows 10 greater than 10.0.10586 (mlocati)
 * bug #19663 Exception details break the layout (Dionysis Arvanitis)
 * bug #19651 [HttpKernel] Fix HttpCache validation HTTP method (tgalopin)
 * bug #19623 [VarDumper] Fix dumping continuations (nicolas-grekas)
 * bug #19549 [HttpFoundation] fixed Request::getContent() reusage bug (1ma)
 * bug #19373 [Form] Skip CSRF validation on form when POST max size is exceeded (jameshalsall)
 * bug #19541 Fix #19531 [Form] DateType fails parsing when midnight is not a valid time (mbeccati)
 * bug #19579 [Process] Strengthen Windows pipe files opening (again...) (nicolas-grekas)
 * bug #19564 Added class existence check if is_subclass_of() fails in compiler passes (SCIF)
 * bug #19522 [SwiftMailerBridge] Fix flawed deprecation message (chalasr)
 * bug #19510 [Process] Fix double-fread() when reading unix pipes (nicolas-grekas)
 * bug #19508 [Process] Fix AbstractPipes::write() for a situation seen on HHVM (at least) (nicolas-grekas)

* 2.8.9 (2016-07-30)

 * bug #19470 undefined offset fix (#19406) (ReenExe)
 * bug #19300 [HttpKernel] Use flock() for HttpCache's lock files (mpdude)
 * bug #19428 [Process] Fix write access check for pipes on Windows (nicolas-grekas)
 * bug #19439 [DependencyInjection] Fixed deprecated default message template with XML (jeremyFreeAgent)
 * bug #19397  [HttpFoundation] HttpCache refresh stale responses containing an ETag (maennchen)
 * bug #19426 [Form] Fix the money form type render with Bootstrap3 (Th3Mouk)
 * bug #19422 [DomCrawler] Inherit the namespace cache in subcrawlers (stof)
 * bug #19425 [BrowserKit] Uppercase the "GET" method in redirects (jakzal)
 * bug #19384 Fix PHP 7.1 related failures (nicolas-grekas)
 * bug #19379 [VarDumper] Fix for PHP 7.1 (nicolas-grekas)
 * bug #19342 Added class existence check if is_subclass_of() fails in compiler passes (SCIF)
 * bug #19369 Fix the DBAL session handler version check for Postgresql (stof)
 * bug #19368 [VarDumper] Fix dumping jsons casted as arrays (nicolas-grekas)
 * bug #19334 [Security] Fix the retrieval of the last username when using forwarding (stof)
 * bug #19321 [HttpFoundation] Add OPTIONS and TRACE to the list of safe methods (dunglas)
 * bug #19317 [BrowserKit] Update Client::getAbsoluteUri() for query string only URIs (georaldc)
 * bug #19298 [ClassLoader] Fix declared classes being computed when not needed (nicolas-grekas)
 * bug #19316 [Validator] Added additional MasterCard range to the CardSchemeValidator (Dennis Væversted)
 * bug #19290 [HttpKernel] fixed internal subrequests having an if-modified-since-header (MalteWunsch)
 * bug #19307 [Security] Fix deprecated usage of DigestAuthenticationEntryPoint::getKey() in DigestAuthenticationListener (Maxime STEINHAUSSER)
 * bug #19309 [DoctrineBridge] added missing error code for constraint. (Koc)
 * bug #19306 [Form] fixed bug - name in ButtonBuilder (cheprasov)
 * bug #19292 [varDumper] Fix missing usage of ExceptionCaster::$traceArgs (nicolas-grekas)
 * bug #19288 [VarDumper] Fix indentation trimming in ExceptionCaster (nicolas-grekas)
 * bug #19267 [Validator] UuidValidator must accept a Uuid constraint. (hhamon)
 * bug #19186 Fix for #19183 to add support for new PHP MongoDB extension in sessions. (omanizer)
 * bug #19253 [Console] Fix block() padding formatting after #19189 (chalasr)
 * bug #19218 [Security][Guard] check if session exist before using it (pasdeloup)

* 2.8.8 (2016-06-30)

 * bug #19217 [HttpKernel] Inline ValidateRequestListener logic into HttpKernel (nicolas-grekas)
 * bug #18688 [HttpFoundation] Warning when request has both Forwarded and X-Forwarded-For (magnusnordlander)
 * bug #19173 [Console] Decouple SymfonyStyle from TableCell (ro0NL)
 * bug #19189 [Console] Fix formatting of SymfonyStyle::comment() (chalasr)
 * bug #19211 [Form] fix post max size translation type extension for >= 2.8 (Tobion)
 * bug #17822 [WIP]  [Form] fix `empty_data` option in expanded `ChoiceType` (HeahDude)
 * bug #19134 Distinguish between first and subsequent progress bar displays (rquadling)
 * bug #19061 [FORM] fix post_max_size_message translation (alt. 2) (David Badura)
 * bug #19100 [Console] Fixed SymfonyQuestionHelper multi-choice with defaults (sstok)
 * bug #18924 [DoctrineBridge] Don't use object IDs in DoctrineChoiceLoader when passing a value closure (webmozart)
 * bug #19138 [DomCrawler] No more exception on field name with strange format (guiled, fabpot)
 * bug #18935 [Form] Consider a violation even if the form is not submitted (egeloen)
 * bug #19127 [Form] Add exception to FormRenderer about non-unique block names (enumag)
 * bug #19118 [Process] Fix pipes cleaning on Windows (nicolas-grekas)
 * bug #19128 Avoid phpunit 5.4 warnings on getMock (2.7+) (iltar)
 * bug #19114 [HttpKernel] Dont close the reponse stream in debug (nicolas-grekas)
 * bug #19101 [Session] fix PDO transaction aborted under PostgreSQL (Tobion)
 * bug #18501 [HttpFoundation] changed MERGE queries (hjkl)
 * bug #19062 [HttpFoundation] Fix UPSERT for PgSql >= 9.5 (nicolas-grekas)
 * bug #18548 [Form] minor fixes in DateTime transformers (HeahDude)
 * bug #18732 [PropertyAccess][DX] Enhance exception that say that some methods are missing if they don't (nykopol)
 * bug #19048 [HttpFoundation] Use UPSERT for sessions stored in PgSql >= 9.5 (nicolas-grekas)
 * bug #19038 Fix feature detection for IE (Alsciende)
 * bug #18915 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #19020 [Form] Fixed collapsed choice attributes (HeahDude)
 * bug #19028 [Yaml] properly count skipped comment lines (xabbuh)
 * bug #19009 [WebProfilerBundle] Fix invalid CSS style (romainneutron)
 * bug #17733 [Yaml] Fix wrong line number when comments are inserted in the middle of a block. (paradajozsef)
 * bug #18911 Fixed singular of committee (peterrehm)
 * bug #18971 Do not inject web debug toolbar on attachments (peterrehm)

* 2.8.7 (2016-06-06)

 * bug #18908 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #18893 [DependencyInjection] Skip deep reference check for 'service_container' (RobertMe)
 * bug #18812 Catch \Throwable (fprochazka)
 * bug #18821 [Form] Removed UTC specification with timestamp (francisbesset)
 * bug #18861 Fix for #18843 (inso)
 * bug #18889 [Console] SymfonyStyle: Fix alignment/prefixing of multi-line comments (chalasr)
 * bug #18907 [Routing] Fix the annotation loader taking a class constant as a beginning of a class name (jakzal, nicolas-grekas)
 * bug #18879 [Console] SymfonyStyle: Align multi-line/very-long-line blocks (chalasr)
 * bug #18864 [Console][DX] Fixed ambiguous error message when using a duplicate option shortcut (peterrehm)
 * bug #18883 Fix js comment in profiler (linnaea)
 * bug #18844 [Yaml] fix exception contexts (xabbuh)
 * bug #18840 [Yaml] properly handle unindented collections (xabbuh)
 * bug #18765 Catch \Throwable (fprochazka)
 * bug #18813 Catch \Throwable (fprochazka)
 * bug #18839 People - person singularization (Keeo)
 * bug #18828 [Yaml] chomp newlines only at the end of YAML documents (xabbuh)
 * bug #18814 Fixed server status command when port has been omitted (peterrehm)
 * bug #18799 Use levenshtein level for better Bundle matching (j0k3r)
 * bug #18413 [WebProfilerBundle] Fix CORS ajax security issues (romainneutron)
 * bug #18774 [console][table] adjust width of colspanned cell. (aitboudad)
 * bug #18507 [BUG] Delete class 'control-group' in bootstrap 3 (Philippe Degeeter)
 * bug #18747  [Form] Modified iterator_to_array's 2nd parameter to false in ViolationMapper (issei-m)
 * bug #18635 [Console] Prevent fatal error when calling Command::getHelper without helperSet (chalasr)
 * bug #18686 [console][table] adjust width of colspanned cell. (aitboudad)
 * bug #18761  [Form] Modified iterator_to_array's 2nd parameter to false in ViolationMapper (issei-m)
 * bug #18737 [Debug] Fix fatal error handlers on PHP 7 (nicolas-grekas)

* 2.8.6 (2016-05-09)

 * security #18736 Fixed issue with blank password with Ldap (csarrazi)
 * security #18733 limited the maximum length of a submitted username (fabpot)
 * bug #18730 [FrameworkBundle] prevent calling get() for service_container service (xabbuh)
 * bug #18705 added a conflict between Monolog bridge 2.8 and HTTP Kernel 3.0+ (fabpot)
 * bug #18709 [DependencyInjection] top-level anonymous services must be public (xabbuh)
 * bug #18388 [EventDispatcher] check for method to exist (xabbuh)
 * bug #18699 [DependencyInjection] Use the priority of service decoration on service with parent (hason)
 * bug #18692 add @Event annotation for KernelEvents (Haehnchen)
 * bug #18246 [DependencyInjection] fix ambiguous services schema (backbone87)

* 2.8.5 (2016-04-29)

 * bug #18180 [Form] fixed BC break with pre selection of choices with `ChoiceType` and its children (HeahDude)
 * bug #18645 [Console] Fix wrong exceptions being thrown (JhonnyL)
 * bug #18562 [WebProfilerBunde] Give an absolute url in case the request occured from another domain (romainneutron)
 * bug #18600 [DI] Fix AutowirePass fatal error with classes that have non-existing parents (hason, nicolas-grekas)
 * bug #18603 [PropertyAccess] ->getValue() should be read-only (nicolas-grekas)
 * bug #18593 [VarDumper] Fix dumping type hints for non-existing parent classes (nicolas-grekas)
 * bug #18596 [DI] Fix internal caching in AutowirePass (nicolas-grekas)
 * bug #18581 [Console] [TableHelper] make it work with SymfonyStyle. (aitboudad)
 * bug #18280 [Routing] add query param if value is different from default (Tobion)
 * bug #18540 Replace iconv_*() uses by mb_*(), add mbstring polyfill when required (nicolas-grekas)
 * bug #18496 [Console] use ANSI escape sequences in ProgressBar overwrite method (alekitto)
 * bug #18490 [LDAP] Free the search result after a search to free memory (hiddewie)
 * bug #18491 [DependencyInjection] anonymous services are always private (xabbuh)
 * bug #18515 [Filesystem] Better error handling in remove() (nicolas-grekas)
 * bug #18360 [PropertyInfo] Extract nullable and collection key type for Doctrine associations (teohhanhui)
 * bug #18449 [PropertyAccess] Fix regression (nicolas-grekas)
 * bug #18429 [Console] Correct time formatting. (camporter)
 * bug #18457 [WebProfilerBundle] Fixed error from unset twig variable (simonsargeant)
 * bug #18467 [DependencyInjection] Resolve aliases before removing abstract services + add tests (nicolas-grekas)
 * bug #18469 Force profiler toolbar svg display (pyrech)
 * bug #18460 [DomCrawler] Fix select option with empty value (Matt Wells)
 * bug #18425 [Security] Fixed SwitchUserListener when exiting an impersonation with AnonymousToken (lyrixx)
 * bug #18317 [Form] fix "prototype" not required when parent form is not required (HeahDude)
 * bug #18439 [Logging] Add support for Firefox (43+) in ChromePhpHandler (arjenm)
 * bug #18385 Detect CLI color support for Windows 10 build 10586 (mlocati)
 * bug #18426 [EventDispatcher] Try first if the event is Stopped (lyrixx)
 * bug #18407 Fixed the "hover" state of the profiler sidebar menu (javiereguiluz)
 * bug #18394 [FrameworkBundle] Return the invokable service if its name is the class name (dunglas)
 * bug #18347 Fixed the styles of the Symfony icon in the web debug toolbar (javiereguiluz)
 * bug #18265 Optimize ReplaceAliasByActualDefinitionPass (ajb-in)
 * bug #18349 [Process] Fix stream_select priority when writing to stdin (nicolas-grekas)
 * bug #18358 [Form] NumberToLocalizedStringTransformer should return floats when possible (nicolas-grekas)
 * bug #17926 [DependencyInjection] Enable alias for service_container (hason)
 * bug #18352 [Debug] Fix case sensitivity checks (nicolas-grekas)
 * bug #18336 [Debug] Fix handling of php7 throwables (nicolas-grekas)
 * bug #18354 [FrameworkBundle][TwigBridge] fix high deps tests (xabbuh)
 * bug #18312 [ClassLoader] Fix storing not-found classes in APC cache (nicolas-grekas)

* 2.8.4 (2016-03-27)

 * bug #18298 [Validator] do not treat payload as callback (xabbuh)
 * bug #18275 [Form] Fix BC break introduced in #14403 (HeahDude)
 * bug #18271 [FileSystem] Google app engine filesystem (swordbeta)
 * bug #18255 [HttpFoundation] Fix support of custom mime types with parameters (Ener-Getick)
 * bug #18272 [Bridge\PhpUnit] Workaround old phpunit bug, no colors in weak mode, add tests (nicolas-grekas)
 * bug #18259 [PropertyAccess] Backport fixes from 2.7 (nicolas-grekas)
 * bug #18261 [PropertyAccess] Fix isPropertyWritable not using the reflection cache (nicolas-grekas)
 * bug #18224 [PropertyAccess] Remove most ref mismatches to improve perf (nicolas-grekas)
 * bug #18237 [WebProfilerBundle] Added table-layout property to AJAX toolbar css (kevintweber)
 * bug #18209 [PropertyInfo] Support Doctrine custom mapping type in DoctrineExtractor (teohhanhui)
 * bug #18210 [PropertyAccess] Throw an UnexpectedTypeException when the type do not match (dunglas, nicolas-grekas)
 * bug #18216 [Intl] Fix invalid numeric literal on PHP 7 (nicolas-grekas)
 * bug #18147 [Validator] EmailValidator cannot extract hostname if email contains multiple @ symbols (natechicago)
 * bug #18023 [Process] getIncrementalOutput should work without calling getOutput (romainneutron)
 * bug #18175 [Translation] Add support for fuzzy tags in PoFileLoader (nud)
 * bug #18179 [Form] Fix NumberToLocalizedStringTransformer::reverseTransform with big integers (ovrflo, nicolas-grekas)
 * bug #18164 [HttpKernel] set s-maxage only if all responses are cacheable (xabbuh)
 * bug #18150 [Process] Wait a bit less on Windows (nicolas-grekas)
 * bug #18130 [Debug] Replaced logic for detecting filesystem case sensitivity (Dan Blows)
 * bug #18137 Autowiring the concrete class too - consistent with behavior of other services (weaverryan)
 * bug #18087 [WebProfiler] Sidebar button padding (rvanlaak)
 * bug #18080 [HttpFoundation] Set the Content-Range header if the requested Range is unsatisfied (jakzal)
 * bug #18084 [HttpFoundation] Avoid warnings when checking malicious IPs (jakzal)
 * bug #18066 [Process] Fix pipes handling (nicolas-grekas)
 * bug #18078 [Console] Fix an autocompletion question helper issue with non-sequentially indexed choices (jakzal)
 * bug #18048 [HttpKernel] Fix mem usage when stripping the prod container (nicolas-grekas)
 * bug #18065 [Finder] Partially revert #17134 to fix a regression (jakzal)
 * bug #18018 [HttpFoundation] exception when registering bags for started sessions (xabbuh)
 * bug #18054 [Filesystem] Fix false positive in ->remove() (nicolas-grekas)
 * bug #18049 [Validator] Fix the locale validator so it treats a locale alias as a valid locale (jakzal)
 * bug #18019 [Intl] Update ICU to version 55 (jakzal)
 * bug #18015 [Process] Fix memory issue when using large input streams (romainneutron)
 * bug #16656 [HttpFoundation] automatically generate safe fallback filename (xabbuh)
 * bug #15794 [Console] default to stderr in the console helpers (alcohol)
 * bug #17984 Allow to normalize \Traversable when serializing xml (Ener-Getick)
 * bug #17434 Improved the error message when a template is not found (rvanginneken, javiereguiluz)
 * bug #17687 Improved the error message when using "@" in a decorated service (javiereguiluz)
 * bug #17744 Improve error reporting in router panel of web profiler (javiereguiluz)
 * bug #17894 [FrameworkBundle] Fix a regression in handling absolute template paths (jakzal)
 * bug #17990 [DoctrineBridge][Form] Fix performance regression in EntityType (kimlai)
 * bug #17595 [HttpKernel] Remove _path from query parameters when fragment is a subrequest (cmenning)
 * bug #17986 [DomCrawler] Dont use LIBXML_PARSEHUGE by default (nicolas-grekas)
 * bug #17668 add 'guid' to list of exception to filter out (garak)
 * bug #17615 Ensure backend slashes for symlinks on Windows systems (cpsitgmbh)
 * bug #17626 Try to delete broken symlinks (IchHabRecht)
 * bug #17978 [Yaml] ensure dump indentation to be greather than zero (xabbuh)
 * bug #16886 [Form] [ChoiceType] Prefer placeholder to empty_value (boite)
 * bug #17976 [WebProfilerBundle] fix debug toolbar rendering by removing inadvertently added links (craue)
 * bug #17971 Variadic controller params (NiR-, fabpot)
 * bug #17876 [DependencyInjection] Fixing autowiring bug when some args are set (weaverryan)
 * bug #17568 Improved Bootstrap form theme for hidden fields (javiereguiluz)
 * bug #17561 [WebProfilerBundle] Fix design issue in profiler when having errors in forms (Pierstoval)
 * bug #17925 [Bridge] The WebProcessor now forwards the client IP (magnetik)

* 2.8.3 (2016-02-28)

 * bug #17947 Fix - #17676 (backport #17919 to 2.3) (Ocramius)
 * bug #17942 Fix bug when using an private aliased factory service (WouterJ)
 * bug #17798  [Form] Fix BC break by allowing 'choice_label' option to be 'false' in ChoiceType (HeahDude)
 * bug #17542 ChoiceFormField of type "select" could be "disabled" (bouland)
 * bug #17602 [HttpFoundation] Fix BinaryFileResponse incorrect behavior with if-range header (bburnichon)
 * bug #17760  [Form] fix choice value "false" in ChoiceType (HeahDude)
 * bug #17914 [Console] Fix escaping of trailing backslashes (nicolas-grekas)
 * bug #17074 Fix constraint validator alias being required (Triiistan)
 * bug #17866 [DependencyInjection] replace alias in factories (xabbuh)
 * bug #17867 [DependencyInjection] replace alias in factory services (xabbuh)
 * bug #17860 Fixed the antialiasing of the toolbar text (javiereguiluz)
 * bug #17569 [FrameworkBundle] read commands from bundles when accessing list (havvg)
 * bug #16987 [FileSystem] Windows fix (flip111)
 * bug #17787 [Form] Fix choice placeholder edge cases (Tobion)
 * bug #17835 [Yaml] fix default timezone to be UTC (xabbuh)
 * bug #17823 [DependencyInjection] fix dumped YAML string (xabbuh)
 * bug #17818 [Console] InvalidArgumentException is thrown under wrong condition (robinkanters)
 * bug #17819 [HttpKernel] Prevent a fatal error when DebugHandlersListener is used with a kernel with no terminateWithException() method (jakzal)
 * bug #17814 [DependencyInjection] fix dumped YAML snytax (xabbuh)
 * bug #17099 [Form] Fixed violation mapping if multiple forms are using the same (or part of the same) property path (alekitto)
 * bug #17694  [DoctrineBridge] [Form] fix choice_value in EntityType (HeahDude)
 * bug #17790 [Config] Fix EnumNodeDefinition to allow building enum nodes with one element (ogizanagi)
 * bug #17729 [Yaml] properly parse lists in object maps (xabbuh)
 * bug #17719 [DependencyInjection] fixed exceptions thrown by get method of ContainerBuilder (lukaszmakuch)
 * bug #17742 [DependencyInjection] Fix #16461 Container::set() replace aliases (mnapoli)
 * bug #17745 Added more exceptions to singularify method (javiereguiluz)
 * bug #17691 Fixed (string) catchable fatal error for PHP Incomplete Class instances (yceruto)
 * bug #17766 Fixed (string) catchable fatal error for PHP Incomplete Class instances (yceruto)
 * bug #17757 [HttpFoundation] BinaryFileResponse sendContent return as parent. (2.3) (SpacePossum)
 * bug #17748 [DomCrawler] Remove the overridden getHash() method to prevent problems when cloning the crawler (jakzal)
 * bug #17725 [WebProfilerBundle] Add width attribute on SVG - Fix toolbar profiler on microsoft edge (AlexandrePavy)
 * bug #17703 [FrameworkBundle] Support autowiring for TranslationInterface (dunglas)
 * bug #17613 [WebProfiler] Fixed logo and menu profiler for Microsoft Edge (WhiteEagle88)
 * bug #17702 [TwigBridge] forward compatibility with Yaml 3.1 (xabbuh)
 * bug #17673 [Routing] add files used in FileResource objects (xabbuh)
 * bug #17672 [DependencyInjection][Routing] add files used in FileResource objects (xabbuh)
 * bug #17669 [Console] remove readline support (xabbuh)
 * bug #17600 Fixed the Bootstrap form theme for inlined checkbox/radio (javiereguiluz)
 * bug #17596 [Translation] Add resources from fallback locale to parent catalogue (c960657)
 * bug #17605 [FrameworkBundle] remove default null value for asset version (xabbuh)
 * bug #17606 [DependencyInjection] pass triggerDeprecationError arg to parent class (xabbuh)
 * bug #16956 [DependencyInjection] XmlFileLoader: enforce tags to have a name (xabbuh)
 * bug #16265 [BrowserKit] Corrected HTTP_HOST logic (Naktibalda)
 * bug #17559 [SecurityBundle] Fix HTTP Digest auth not being passed user checker (SamFleming)
 * bug #17554 [DependencyInjection] resolve aliases in factories (xabbuh)
 * bug #17555 [DependencyInjection] resolve aliases in factory services (xabbuh)
 * bug #17511 [Form] ArrayChoiceList can now deal with a null in choices (issei-m)
 * bug #17430 [Serializer] Ensure that groups are strings (dunglas)
 * bug #15272 [FrameworkBundle] Fix template location for PHP templates (jakzal)
 * bug #11232 [Routing] Fixes fatal errors with object resources in AnnotationDirectoryLoader::supports (Tischoi)
 * bug #17526 Escape the delimiter in Glob::toRegex (javiereguiluz)
 * bug #17527 fixed undefined variable (fabpot)
 * bug #15706 [framework-bundle] Added support for the `0.0.0.0/0` trusted proxy (zerkms)
 * bug #16274 [HttpKernel] Lookup the response even if the lock was released after two second wait (jakzal)
 * bug #16954 [TranslationUpdateCommand] fixed undefined resultMessage var. (aitboudad)
 * bug #17355 [DoctrineBridge][Validator] >= 2.3 Pass association instead of ID as argument (xavismeh)
 * bug #17330 Limit the max height/width of icons in the profiler menu (javiereguiluz)
 * bug #17454 Allow absolute URLs to be displayed in the debug toolbar (javiereguiluz)
 * bug #16736 [Request] Ignore invalid IP addresses sent by proxies (GromNaN)
 * bug #17459 [EventDispatcher] TraceableEventDispatcher resets event listener priorities (c960657)
 * bug #17486 [FrameworkBundle] Throw for missing container extensions (kix)
 * bug #16961 Overriding profiler position in CSS breaks JS positioning (aschempp)
 * bug #16873 Able to load big xml files with DomCrawler (zorn-v)
 * bug #16897 [Form] Fix constraints could be null if not set (DZunke)
 * bug #16912 [Translation][Writer] avoid calling setBackup if the dumper is not FileDumper (aitboudad)
 * bug #17505 sort bundles in config:dump-reference command (xabbuh)
 * bug #17514 [Asset] Add defaultNull to version configuration (ewgRa)
 * bug #16511 [Asset] Ability to set empty version strategy in packages (ewgRa)
 * bug #17457 Display Ajax requests from newest to oldest in the toolbar (javiereguiluz)
 * bug #17503 [Asset] CLI: use request context to generate absolute URLs (xabbuh)
 * bug #17478 [HttpFoundation] Do not overwrite the Authorization header if it is already set (jakzal)
 * bug #17461 [Yaml] tag for dumped PHP objects must be a local one (xabbuh)
 * bug #16822 [FrameworkBundle][Validator] Fix apc cache service deprecation (ogizanagi)
 * bug #17463 [Form] make tests compatible with Symfony 2.8 and 3.0 (xabbuh)
 * bug #17456 [DX] Remove default match from AbstractConfigCommand::findExtension (kix)
 * bug #17424 [Process] Update in 2.7 for stream-based output storage (romainneutron)
 * bug #17417 Fixed the form profiler when using long form types (javiereguiluz)
 * bug #17423 [Process] Use stream based storage to avoid memory issues (romainneutron)
 * bug #17406 [Form] ChoiceType: Fix a notice when 'choices' normalizer is replaced (paradajozsef)
 * bug #17433 [FrameworkBundle] Don't log twice with the error handler (nicolas-grekas)
 * bug #17418 Fixed Bootstrap form theme form "reset" buttons (javiereguiluz)
 * bug #17416 [PropertyInfo] PhpDocExtractor: Fix a notice when the property doesn'… (dunglas)
 * bug #17404 fix merge 2.3 into 2.7 for SecureRandom dependency (Tobion)
 * bug #17373 [SecurityBundle] fix SecureRandom service constructor args (Tobion)
 * bug #17382 [TwigBridge] Use label_format option for checkbox and radio labels (enumag)
 * bug #17380 [TwigBridge] Use label_format option for checkbox and radio labels (enumag)
 * bug #17377 Fix performance (PHP5) and memory (PHP7) issues when using token_get_all (nicolas-grekas, peteward)
 * bug #17389 [Routing] Fixed correct class name in thrown exception (fixes #17388) (robinvdvleuten)
 * bug #17358 [ClassLoader] Use symfony/polyfill-apcu (nicolas-grekas)
 * bug #17370 [HttpFoundation][Cookie] Cookie DateTimeInterface fix (wildewouter)

* 2.8.2 (2016-01-14)

 * security #17359 do not ship with a custom rng implementation (xabbuh, fabpot)
 * bug #17253 [Console] HHVM read input stream bug (mbutkereit)
 * bug #17314 Fix max width for multibyte keys in choice question (mheki)
 * bug #17326 [Console] Display console application name even when no version set (polc)
 * bug #17328 [Serializer] Allow to use proxies in object_to_populate (dunglas)
 * bug #17202 [FrameworkBundle] Don't log twice with the error handler (nicolas-grekas)
 * bug #17347  Workaround https://bugs.php.net/63206 (nicolas-grekas)
 * bug #17199 [Serializer] Allow context to contain not serializable data (dunglas, nicolas-grekas)
 * bug #17334 [WebProfiler] Fixed sf-minitoolbar height (yceruto)
 * bug #17140 [Serializer] Remove normalizer cache in Serializer class (jvasseur)
 * bug #17320 [Debug] Fixed erroneous deprecation notice for extended Interfaces (peterrehm)
 * bug #17307 [FrameworkBundle] Fix paths with % in it (like urlencoded) (scaytrase)
 * bug #17078 [Bridge] [Doctrine] [Validator] Added support \IteratorAggregate for UniqueEntityValidator (Disparity)
 * bug #17298 [FrameworkBundle] Use proper class to fetch $versionStrategy property (dosten)
 * bug #17287 [HttpKernel] Forcing string comparison on query parameters sort in UriSigner (Tim van Densen)
 * bug #17279 [FrameworkBundle] Add case in Kernel directory guess for PHPUnit (tgalopin)
 * bug #17278 [FrameworkBundle] Add case in Kernel directory guess for PHPUnit (tgalopin)
 * bug #17283 [WebProfilerBundle] Remove loading status from AJAX toolbar after error (kucharovic)
 * bug #17275 [PhpUnitBridge] Re-enable the garbage collector (nicolas-grekas)
 * bug #17276 [Process] Fix potential race condition (nicolas-grekas)
 * bug #17261 [FrameworkBundle] Allow to autowire service_container (dunglas)
 * bug #17183 [FrameworkBundle] Set the kernel.name properly after a cache warmup (jakzal)
 * bug #17197 [Yaml] cast arrays to objects after parsing has finished (xabbuh)
 * bug #17247 Fix toolbar display when nvd3 is loaded on page (Seldaek)
 * bug #17159 [Yaml] recognize when a block scalar is left (xabbuh)
 * bug #17195 bug #14246 [Filesystem] dumpFile() non atomic (Hidde Boomsma)
 * feature #16747 [Form] Improved performance of ChoiceType and its subtypes (webmozart)
 * bug #17179 [WebProfiler] Removed an object as route generator argument (iltar)
 * bug #17177 [Process] Fix potential race condition leading to transient tests (nicolas-grekas)
 * bug #17163 [Form] fix Catchable Fatal Error if choices is not an array (Gladhon, nicolas-grekas)
 * bug #17152 [DoctrineBridge] [PropertyInfo] Catch Doctrine\ORM\Mapping\MappingException (dunglas)
 * bug #17119 [Form] improve deprecation message for "empty_value" and "choice_list" options. (hhamon)
 * bug #17156 [HttpFoundation] add missing symfony/polyfill-php55 dependency (xabbuh)
 * bug #17162 [Form] Fix regression on Collection type (hason)

* 2.8.1 (2015-12-26)

 * bug #16864 [Yaml] fix indented line handling in folded blocks (xabbuh)
 * bug #17052  Fixed flatten exception recursion with errors (GrahamCampbell)
 * bug #16826 Embedded identifier support (mihai-stancu)
 * bug #17079 Also transform inline mappings to objects (WouterJ)
 * bug #17129 [Config] Fix array sort on normalization in edge case (romainneutron)
 * feature #17035 [DomCrawler] Revert previous restriction, allow selection of every DOMNode object  (EdgarPE)
 * bug #17094 [Process] More robustness and deterministic tests (nicolas-grekas)
 * bug #17112 [PropertyAccess] Reorder elements array after PropertyPathBuilder::replace (alekitto)
 * bug #17109 Improved the design of the web debug toolbar (javiereguiluz)
 * bug #16797 [Filesystem] Recursivly widen non-executable directories (Slamdunk)
 * bug #16926 [DependencyInjection] fixed definition loosing property shared when decorated by a parent definition (wahler)
 * bug #17040 [Console] Avoid extra blank lines when rendering exceptions (ogizanagi)
 * bug #17044 [Form] fix BC break introduced with prototype_data option (memphys)
 * bug #17055 [Security] Verify if a password encoded with bcrypt is no longer than 72 characters (jakzal)
 * bug #16959 [Form] fix #15544 when a collection type attribute "required" is false, "prototype" should too (HeahDude)
 * bug #16806 [Validator] BicValidator - fixed raising violations to a maximum of one (mvhirsch)
 * bug #16842 [Ldap] Escape carriage returns in LDAP DNs. (ChadSikorra)
 * bug #16860 [Yaml] do not remove "comments" in scalar blocks (xabbuh)
 * bug #17002 [Console][Table] fixed render row that contains multiple cells. (aitboudad)
 * bug #16964 CSS min-height and min-width should not be "auto" (aschempp)
 * bug #16971 [HttpFoundation] Added the ability of using BinaryFileResponse with stream wrappers (jakzal, Sander-Toonen)
 * bug #17048 Fix the logout path when not using the router (stof)
 * bug #17049 Fix the logout path when not using the router (stof)
 * bug #17057 [FrameworkBundle][HttpKernel] the finder is required to discover bundle commands (xabbuh)
 * bug #17059 [HttpFoundation] fix error level for deprecation (xabbuh)
 * bug #17006 [Form] Fix casting regression in DoctrineChoiceLoader (bendavies)
 * bug #16911 [PropertyInfo] Update List Information from ReflectionExtractor (zanderbaldwin)
 * bug #16955 [FrameworkBundle] ContainerDebugCommand: pass the right object to the descriptors (xabbuh)
 * feature #16760 Show silenced errors in separate tab (peterrehm)
 * feature #16937 [PhpUnitBridge] Replace "weak-verbose" by "deprecations upper bound" mode (nicolas-grekas)
 * bug #16915 [Process] Enhance compatiblity with --enable-sigchild (nicolas-grekas)
 * bug #16829 [FrameworkBundle] prevent cache:clear creating too long paths (Tobion)
 * bug #16922 [FrameworkBundle] [Bug] Fixes new InputStyle bug #16920 (AlmogBaku)
 * bug #16921 Fix short array syntax for php 5.3 (ewgRa)
 * bug #16450 [Serializer] Fixed `array_unique` on array of objects in `getAllowedAttributes`. (CornyPhoenix)
 * bug #16757 [FrameworkBundle] [Translation] Fixed translations not written when no translations directory in update command (jeremyFreeAgent)
 * bug #16902 [Security] Fix a Polyfill import statement in StringUtils (magnetik)
 * bug #16871 [FrameworkBundle] Disable built-in server commands when Process component is missing (gnugat, xabbuh)
 * bug #16870 [FrameworkBundle] Disable the server:run command when Process component is missing (gnugat, xabbuh)
 * feature #16789 [PhpUnitBridge] Add weak-verbose mode and match against message instead of test name (nicolas-grekas)
 * bug #16796 [Form] Fix choices defined as Traversable (nicolas-grekas)
 * bug #16742 [Console][ProgressBar] redrawFrequency should never be 0 (dritter)
 * bug #16846 [MonologBridge] Monolog Bridge 2.8 is incompatible with HttpKernel 3.0 (derrabus)
 * bug #16799 Improve error message for undefined DIC aliases (mpdude)
 * bug #16825 [VarDumper] fix .sf-dump z-index (debug bar conflict) (Antoine LA)
 * bug #16772 Refactoring EntityUserProvider::__construct() to not do work, cause cache warm error (weaverryan)

* 2.8.0 (2015-11-30)

 * bug #16758 Fix BC for the default root form name (stof)
 * bug #16753 [Process] Fix signaling/stopping logic on Windows (nicolas-grekas)
 * feature #16755 [Security] add subject variable to expression context (xabbuh)
 * bug #16642 [DI][autowiring] throw exception when many services use the same class. (aitboudad)
 * bug #16745 [Yaml] look for colon in parsed inline string (xabbuh)
 * bug #16733 [Console] do not encode backslashes in console default description (Tobion)
 * feature #16735 [WIP] [Ldap] Marked the Ldap component as internal (csarrazi)
 * bug #16734 Make sure security.role_hierarchy.roles always exists (WouterJ)
 * feature #16722 [Security][SecurityBundle] Use csrf_token_id instead of deprecated intention (jakzal)
 * bug #16312 [HttpKernel] clearstatcache() so the Cache sees when a .lck file has been released (mpdude)
 * bug #16351 [WIP] [Form] [TwigBridge] Bootstrap horizontal theme missing tests (pieter2627)
 * bug #16685 [Form] Fixed: Duplicate choice labels are remembered when using "choices_as_values" = false (webmozart)
 * feature #16709 [Bridge\PhpUnit] Display the stack trace of a deprecation on-demand (nicolas-grekas)
 * bug #16704 [Form+SecurityBundle] Trigger deprecation for csrf_provider+intention options (nicolas-grekas)
 * feature #16706 [HttpFoundation] Deprecate $deep parameter on ParameterBag (nicolas-grekas)
 * bug #16705 [Form] Deprecated setting "choices_as_values" to "false" (webmozart)
 * feature #16690 [Form] Deprecated ArrayKeyChoiceList (webmozart)
 * feature #16687 [Form] Deprecated TimezoneType::getTimezones() (webmozart)
 * bug #16681 [Form] Deprecated setting "choices_as_values" to "false" (webmozart)
 * bug #16695 [SecurityBundle] disable the init:acl command if ACL is not used (Tobion)
 * bug #16677 [Form] Fixed wrong usages of the "text" type (webmozart)
 * bug #16679 [Form] Disabled view data validation if "data_class" is set to null (webmozart)
 * bug #16621 [Console] Fix bug with $output overloading (WouterJ)
 * feature #16601 [Security] Deprecate "AbstractVoter" in favor of "Voter" (nicolas-grekas, lyrixx)
 * bug #16676 [HttpFoundation] Workaround HHVM rewriting HTTP response line (nicolas-grekas)
 * bug #16668 [ClassLoader] Fix parsing namespace when token_get_all() is missing (nicolas-grekas)
 * bug #16386 Bug #16343 [Router] Too many Routes ? (jelte)
 * bug #16498 fix unused variable warning (eventhorizonpl)
 * feature #16031 [Translation][Form] Do not translate form labels and placeholders when 'translation_domain' is false (Restless-ET)
 * bug #16651 [Debug] Ensure class declarations are loaded only once (nicolas-grekas)
 * security #16631 CVE-2015-8124: Session Fixation in the "Remember Me" Login Feature (xabbuh)
 * security #16630 CVE-2015-8125: Potential Remote Timing Attack Vulnerability in Security Remember-Me Service (xabbuh)
 * bug #16633 [Filesystem] Fixed failing test due to tempdir symlink (toretto460)
 * bug #16609 [HttpKernel] Don't reset on shutdown but in FrameworkBundle/Test/KernelTestCase (nicolas-grekas)
 * bug #16477 [Routing] Changing RouteCollectionBuilder::import() behavior to add to the builder (weaverryan)
 * bug #16588 Sent out a status text for unknown HTTP headers. (dawehner)
 * bug #16295 [DependencyInjection] Unescape parameters for all types of injection (Nicofuma)
 * bug #16377 [WebProfilerBundle] Fix minitoolbar height (rvanlaak)
 * bug #16585 Add support for HTTP status code 418 back (dawehner)
 * bug #16574 [Process] Fix PhpProcess with phpdbg runtime (nicolas-grekas)
 * bug #16581 Fix call to undefined function json_last_error_message (dawehner)
 * bug #16573 [FrameworkBundle] Fix PropertyInfo extractor namespace in framework bundle (jvasseur)
 * bug #16578 [Console] Fix bug in windows detection (kbond)
 * bug #16546 [Serializer] ObjectNormalizer: don't serialize static methods and props (dunglas)
 * bug #16352 Fix the server variables in the router_*.php files (leofeyer)
 * bug #16537 [Validator] Allow an empty path with a non empty fragment or a query (jakzal)
 * bug #16528 [Translation] Add support for Armenian pluralization. (marcosdsanchez)
 * bug #16510 [Process] fix Proccess run with pts enabled (ewgRa)

* 2.8.0-BETA1 (2015-11-16)

 * feature #16156 [Filesystem] Changed dumpFile to allow dumping to streams (markchalloner, pierredup)
 * feature #16502 [Bridge\PhpUnit] Add extra clock-mocked namespaces in phpunit.xml.dist (nicolas-grekas)
 * feature #16464 [DependencyInjection] Fix some edge cases with autowiring (dunglas)
 * feature #16433 [Yaml] deprecate unquoted indicator characters (xabbuh)
 * feature #16419 [FrameworkBundle][Form] Better exception message for private form tagged services (ogizanagi)
 * feature #15990 added a micro kernel (fabpot)
 * feature #16459 [Security\Core] Deprecate passing $salt to BCryptPasswordEncoder::encodePassword() (nicolas-grekas)
 * feature #16409 [Console] Add progress indicator helper (kbond)
 * feature #16423 [VarDumper] Deprecate VarDumperTestCase in favor of the trait (nicolas-grekas)
 * feature #16424 [DI] Deprecate ContainerAware in favor of ContainerAwareTrait (nicolas-grekas)
 * feature #16430 [HttpKernel] PostResponseEvent should extend the KernelEvent (jakzal)
 * feature #16325 [VarDumper] Casters for Generator, ReflectionGenerator and ReflectionType (nicolas-grekas)
 * feature #16395 checkCredentials() force it to be an affirmative yes! (weaverryan)
 * feature #16344 [WebProfilerBundle] Filter links in search results (Rvanlaak)
 * feature #16285 [Yaml] deprecated usage of @ and ` at the beginning of an unquoted string (fabpot)
 * feature #16317 Rely on iconv and symfony/polyfill-* (nicolas-grekas)
 * feature #15966 [FrameworkBundle] PropertyInfo support (dunglas)
 * feature #16161 [Validator] Add expressionLanguage to ExpressionValidator constructor (enumag)
 * feature #16263 [FrameworkBundle] Add a new ClassCache cache warmer (tucksaun)
 * feature #16271 [TwigBundle] added a Twig templates warmer when templating is disabled (fabpot)
 * feature #16276 Unify URL generator reference type + make linking in php templates consistent with twig (Tobion)
 * feature #15947 Added UserLoaderInterface for loading users through Doctrine. (mtrojanowski)
 * feature #16194 [PhpUnit] Mock clock on @group time-sensitive annotations (nicolas-grekas)
 * feature #16201 [Yaml] deprecated non-escaped \ in double-quoted strings when parsing (fabpot)
 * feature #16198 [EventDispatcher] added EventDispatcher::getListenerPriority() (fabpot)
 * feature #15025 [2.8] [Form] Rename CollectionType options for entries (WouterJ)
 * feature #16189 [PhpUnitBridge] Add SkippedTestsListener to collect and replay skipped tests (nicolas-grekas)
 * feature #15879 Deprecate the SecureRandom class (pierredup)
 * feature #16001 [DI] Warn when a definition relies on a deprecated class in ContainerBuilder::createService() (nicolas-grekas)
 * feature #14044 [Console] [Helper] [Table] Columns styles (MAXakaWIZARD)
 * feature #14908 Include working directory in ProcessFailedException (Rvanlaak)
 * feature #16102 Simplify AbstractVoter (Koc)
 * feature #15613 [DependencyInjection] Add autowiring capabilities (dunglas)
 * feature #14721 [Security] Configuring a user checker per firewall (iltar)
 * feature #16069 [WebProfilerBundle] Move AjaxCollector to HttpKernel for use with Silex (glaubinix, fabpot)
 * feature #16063 [VarDumper] Add $this->getDump($var) when using VarDumperTestTrait (nicolas-grekas)
 * feature #16058 Prevent adding non-DOMElement elements in DomCrawler (stof)
 * feature #16057 Deprecate loading multiple documents in the same crawler (stof)
 * feature #15742 Using a service as a router resource (weaverryan)
 * feature #15778 Fluid interface for building routes in PHP (weaverryan)
 * feature #16029 [FrameworkBundle][TwigBridge] do not render empty form action attributes (xabbuh)
 * feature #15938 [Console] Bind input before executing the COMMAND event (WouterJ)
 * feature #15503 UI & CSS improvement to new toolbar (WouterJ)
 * feature #15838 [VarDumper] Dump PHP+Twig code excerpts in backtraces (nicolas-grekas)
 * feature #16011 [FrameworkBundle] Tag deprecated services (nicolas-grekas)
 * feature #15944 Remove profiler storages (javiereguiluz)
 * feature #16007 [HttpFoundation] deprecate finding deep items in request parameters (xabbuh)
 * feature #15978 Updated the styles of the cache commands (javiereguiluz)
 * feature #15972 [Console] Updated the styles of the server commands (javiereguiluz)
 * feature #15964 Symfony Console Style tweaks (javiereguiluz)
 * feature #15919 [Form] Guess currency field based on validator constraint (enumag)
 * feature #15934 Add a non-static API for the CssSelector component (stof)
 * feature #14235 [FrameworkBundle] Refactored assets:install command and apply Symfony styles (1ed)
 * feature #15963 added logging of unused tags (Marmelatze, fabpot)
 * feature #15970 [TwigBundle] removed usage of Templating classes (fabpot)
 * feature #14132 Applied the new styles to the router: commands (javiereguiluz)
 * feature #15356 [WebProfilerBundle] Profiler View Latest should preserve all the current query parameters (jbafford)
 * feature #15953 [TwigBridge] is_granted no longer raise an exception if the token storage is empty (lyrixx)
 * feature #14602 [2.8] [Ldap] Added support for LDAP (New Component + integration in the Security Component). (csarrazi, lyrixx)
 * feature #15939 Removed the "Delete profiles" action from the web profiler sidebar (javiereguiluz)
 * feature #15962 [Finder] simplified code (fabpot)
 * feature #15882 Easier Custom Authentication errors (weaverryan)
 * feature #15907 [DomCrawler] Deprecate methods inherited from SplObjectStorage (stof)
 * feature #15301 [Form][Type Date/Time] added choice_translation_domain option. (aitboudad)
 * feature #15697 [BrowserKit] Added isFollowingRedirects and getMaxRedirects methods (Naktibalda)
 * feature #15719 Deprecate ResourceInterface::getResource() (mpdude)
 * feature #15818 [WebProfilerBundle] Add collapsed sidebar on small screens (hason)
 * feature #15858 [PropertyInfo] Import the component (dunglas)
 * feature #15892 deprecated the Shell Console class (fabpot)
 * feature #15519 [Validator] added BIC (SWIFT-BIC) validation constraint (mvhirsch)
 * feature #12587 [TwigBridge] Foundation form layout integration (totophe)
 * feature #15151 [Security] Deprecated supportsAttribute and supportsClass methods (WouterJ)
 * feature #15491 Add support for deprecated definitions (Taluu)
 * feature #14894 [Console] Add domain exceptions to replace generic exceptions (GromNaN)
 * feature #15738 Implement service-based Resource (cache) validation (mpdude)
 * feature #14673 New Guard Authentication System (e.g. putting the joy back into security) (weaverryan)
 * feature #15870 Updating AbstractVoter so that the method receives the TokenInterface (weaverryan)
 * feature #15786 [Translation][File dumper] allow get file content without writing in file. (aitboudad)
 * feature #15805 [Finder] Deprecate adapters and related classes (nicolas-grekas)
 * feature #15837 [VarDumper] Add EnumStub for dumping virtual collections with casters (nicolas-grekas)
 * feature #15699 [Translator][FileDumper] deprecated format method in favor of formatCatalogue. (aitboudad)
 * feature #15717 [Translator][Loader] added XLIFF 2.0 support. (xphere, aitboudad)
 * feature #15743 Validate the extended type for lazy-loaded type extensions (stof)
 * feature #13761 Automatically process extensions when they implement CompilerPassInterface (WouterJ)
 * feature #15787 [VarDumper] Add caster for OuterIterator objects (nicolas-grekas)
 * feature #13616 [HttpKernel] Add entry point to more easily create/configure the DI extension (egeloen)
 * feature #14378 [DX] Added a logout link in the security panel of the web debug toolbar (javiereguiluz)
 * feature #15620 [WIP] #15502 Make template shortcuts be usable without Templating component (Koc)
 * feature #15523 Redesigned the Symfony Profiler (javiereguiluz)
 * feature #15773 Make the exception output visible even in quiet mode, fixes #15680 (Seldaek)
 * feature #15772 Convert Output::write's type to an options arg where verbosity can be passed in as well (Seldaek)
 * feature #15756 [Translation] added option json_options to JsonFileDumper. (gepo)
 * feature #15724 [HttpKernel] Move required RequestStack args as first arguments (nicolas-grekas)
 * feature #15521 [Debug] Add BufferingLogger for errors that happen before a proper logger is configured (nicolas-grekas)
 * feature #15709 [WebProfilerBundle] deprecated import/export commands (fabpot)
 * feature #15710 added ExceptionHandler::getHtml() to expose the full HTML of an exception (fabpot)
 * feature #15562 [translation] Deprecated DiffOperation (zerustech)
 * feature #15635 [Config] Prototypes info (ogizanagi)
 * feature #15551 [Translation] added <tool> element metadata to XliffFileDumper (aitboudad)
 * feature #15555 [VarDumper] Add caster for pgsql resources (nicolas-grekas)
 * feature #15452 [Translator] [Xliff] Add support for target attributes. (marcosdsanchez)
 * feature #15416 [DependencyInjection] Added a way to define the priority of service decoration (dosten)
 * feature #15433 Allow to define Enum nodes with 1 single element (javiereguiluz)
 * feature #13990 [Form] Add flexibility for EntityType (raziel057)
 * feature #15382 [Console] Use readline for user input when available #DX (michaelperrin)
 * feature #15013 [Security] Removed security-acl from the core (iltar)
 * feature #15079 [Form] Deprecated FormTypeInterface::getName() and passing of type instances (webmozart)
 * feature #15418 [Debug] Deprecate ExceptionHandler::createResponse (nicolas-grekas)
 * feature #15123 [2.8][FrameworkBundle] Allow parameter use_cookies in session configuration (derrabus)
 * feature #14987 [FrameworkBundle] Configurable Serializer name converter (dunglas)
 * feature #15285 [Config] deprecate cannotBeEmpty() for boolean and numeric nodes (xabbuh)
 * feature #15372 [FrameworkBundle] Change the default value of cookie_httponly (jderusse)
 * feature #15160 Redesigned the web debug toolbar (javiereguiluz)
 * feature #15185 Implement resettable containers (stof)
 * feature #15131 [Security] Moved Simple{Form,Pre}AuthenticatorInterfaces to Security\Http (WouterJ)
 * feature #15290 [DependencyInjection] Forbid container cloning (jakzal)
 * feature #14264 [WebProfilerBundle] Add link to show profile of latest request (xelaris)
 * feature #15139 [Translation] Add parameters to DataCollectorTranslator (damienalexandre)
 * feature #15175 [VarDumper] Ingore PHPUnit and Prophecy object when they are nested (lyrixx)
 * feature #15141 [DX] [Security] Renamed Token#getKey() to getSecret() (WouterJ)
 * feature #15154 [Validator] Added missing error codes and turned codes into UUIDs (webmozart)
 * feature #15096 [DependencyInjection] Allow anonymous DefinitionDecorator resolving (nicolas-grekas)
 * feature #14764 [TwigBundle] Warmup twig templates in non-standard paths (kbond)
 * feature #15134 [FrameworkBundle] add option to force web server startup (xabbuh)
 * feature #14238 [config] added remove option to ignoreExtraKeys (twifty)
 * feature #15076 [Debug] Allow throwing from __toString() with `return trigger_error($e, E_USER_ERROR);` (nicolas-grekas)
 * feature #14984 [DependencyInjection] Deprecate scope concept (dosten)
 * feature #14429 [FrameworkBundle] Add a doctrine cache service definition for validator mapping (jakzal)
 * feature #14991 [Console][Table] allow multiple render() calls. (jaytaph)
 * feature #14660 [Form] moved data trimming logic of TrimListener into StringUtil (issei-m)
 * feature #15019 [Form] Deprecated "cascade_validation" (webmozart)
 * feature #12314 [Form] Add "prototype_data" option to collection type (kgilden)
 * feature #12067 [Form] Added the 'range' FormType (jaytaph)
 * feature #14993 [Profiler][Translation] added filter. (aitboudad)
 * feature #14912 [HttpFoundation] Postpone setting the date header on a Response (jakzal)
 * feature #14903 [profiler][request toolbar] Removed route name from the toolbar (MJBGO)
 * feature #14904 [toolbar] Merged colored icons in toolbar (MJBGO)
 * feature #14781 [TwigBundle] Reconfigure twig paths when they are updated (chbruyand)
 * feature #14700 [DependencyInjection] [Routing] [Config] Recursive directory loading (lavoiesl, nicolas-grekas)
 * feature #14733 [Security] Add setVoters() on AccessDecisionManager (nicolas-grekas)
 * feature #14756 [Serializer] Support for array denormalization (derrabus)
 * feature #14630 [Translator] Dump translation constants as tree instead of simple list (gepo)
 * feature #14403 [Form] deprecate read_only option (Tobion)
 * feature #13324 [WebProfilerBundle] Improved page for logs (hason)
 * feature #14561 [FrameworkBundle][DX] Add option to specify additional translation loading paths (Seldaek)
 * feature #14563 [FrameworkBundle][EventDispatcher] Add priorities to the debug:event-dispatcher command (Seldaek)
 * feature #14546 [Translator] deprecate getMessages in favor of getCatalogue. (aitboudad)
 * feature #14320 [Translation] added an --all option to the debug:translation command #14237 (sgehrig)
 * feature #14473 [DX] Minor improvement for the translation:debug output (nicolasdewez)
 * feature #14443 [VarDumper] Allow preserving a subset of cut arrays (nicolas-grekas)
 * feature #14431 [Console] Bind the closure (code) to the Command if possible (lyrixx)
 * feature #14424 [VarDumper] Added support for SplFileInfo (lyrixx)
 * feature #14359 [Translation] added FileLoader. (aitboudad)
 * feature #14383 [FrameworkBundle][Server Command] add address port number option. (aitboudad)
